/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import minium.web.StatefulWebDriver;
import minium.web.config.WebDriverProperties;
import minium.web.config.services.ChromeDriverServiceProperties;
import minium.web.config.services.DriverServicesProperties;
import minium.web.config.services.FirefoxDriverServiceProperties;
import minium.web.config.services.InternetExplorerDriverServiceProperties;
import minium.web.config.services.PhantomJsDriverServiceProperties;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariDriver;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class WebDriverFactory {
    private final DriverServicesProperties driverServices;

    public WebDriverFactory(DriverServicesProperties driverServices) {
        this.driverServices = driverServices;
    }

    public WebDriver create(WebDriverProperties webDriverProperties) throws IOException {
        WebDriverProperties.FirefoxProfileProperties firefoxProperties;
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(webDriverProperties.getDesiredCapabilities());
        WebDriverProperties.ChromeOptionsProperties chromeProperties = webDriverProperties.getChromeOptions();
        if (chromeProperties != null) {
            desiredCapabilities.setCapability("chromeOptions", (Object)this.configureChromeOptions(chromeProperties));
        }
        if ((firefoxProperties = webDriverProperties.getFirefoxProfile()) != null) {
            desiredCapabilities = new FirefoxOptions().setProfile(this.getFirefoxProfile(firefoxProperties)).addCapabilities((Capabilities)desiredCapabilities).addTo(DesiredCapabilities.firefox());
        }
        RemoteWebDriver webDriver = null;
        if (webDriverProperties.getUrl() != null) {
            RemoteWebDriver remoteDriver = new RemoteWebDriver(webDriverProperties.getUrl(), (Capabilities)desiredCapabilities);
            remoteDriver.setFileDetector((FileDetector)new LocalFileDetector());
            webDriver = remoteDriver;
        } else {
            String browserName;
            String string = browserName = desiredCapabilities == null ? null : desiredCapabilities.getBrowserName();
            if (Strings.isNullOrEmpty((String)browserName)) {
                browserName = "chrome";
            }
            webDriver = WebDriverType.typeFor(browserName).create(this, desiredCapabilities);
        }
        WebDriverProperties.WindowProperties window = webDriverProperties.getWindow();
        if (window != null) {
            WebDriverProperties.DimensionProperties size = window.getSize();
            WebDriverProperties.PointProperties position = window.getPosition();
            if (size != null) {
                webDriver.manage().window().setSize(new Dimension(size.getWidth(), size.getHeight()));
            }
            if (position != null) {
                webDriver.manage().window().setPosition(new Point(position.getX(), position.getY()));
            }
            if (window.isMaximized()) {
                webDriver.manage().window().maximize();
            }
        }
        webDriver = webDriver instanceof TakesScreenshot ? webDriver : new Augmenter().augment((WebDriver)webDriver);
        for (WebDriverTransformer transformer : this.driverServices.getWebDriverTranformers()) {
            webDriver = transformer.transform((WebDriver)webDriver);
        }
        return webDriverProperties.isStateful() ? new StatefulWebDriver((WebDriver)webDriver) : webDriver;
    }

    private ChromeOptions configureChromeOptions(WebDriverProperties.ChromeOptionsProperties chromeProperties) {
        ChromeOptions options = new ChromeOptions();
        if (chromeProperties.getArgs() != null) {
            options.addArguments(chromeProperties.getArgs());
        }
        if (chromeProperties.getBinary() != null) {
            options.setBinary(chromeProperties.getBinary());
        }
        if (chromeProperties.getExtensions() != null) {
            options.addExtensions(chromeProperties.getExtensions());
        }
        if (chromeProperties.getPreferences() != null) {
            options.setExperimentalOption("prefs", chromeProperties.getPreferences());
        }
        return options;
    }

    private FirefoxProfile getFirefoxProfile(WebDriverProperties.FirefoxProfileProperties firefoxProperties) throws IOException {
        List<WebDriverProperties.ExtensionProperties> extensions;
        File profileDirectory = null;
        String profileDir = firefoxProperties.getDir();
        if (profileDir != null) {
            profileDirectory = new File(profileDir);
        }
        FirefoxProfile profile = new FirefoxProfile(profileDirectory);
        List<WebDriverProperties.PreferenceProperties> preferences = firefoxProperties.getPreferences();
        if (preferences != null) {
            for (WebDriverProperties.PreferenceProperties preference : preferences) {
                switch (preference.getType()) {
                    case BOOLEAN: {
                        profile.setPreference(preference.getName(), ((Boolean)preference.getValue()).booleanValue());
                        break;
                    }
                    case INTEGER: {
                        profile.setPreference(preference.getName(), ((Integer)preference.getValue()).intValue());
                        break;
                    }
                    case STRING: {
                        profile.setPreference(preference.getName(), (String)preference.getValue());
                    }
                }
            }
        }
        if ((extensions = firefoxProperties.getExtensions()) != null) {
            DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
            for (WebDriverProperties.ExtensionProperties firefoxExtension : extensions) {
                Resource extensionPath = resourceLoader.getResource(firefoxExtension.getPath());
                FileExtension extension = new FileExtension(extensionPath.getFile());
                profile.addExtension(firefoxExtension.getName(), (Extension)extension);
            }
        }
        profile.setAlwaysLoadNoFocusLib(firefoxProperties.shouldLoadNoFocusLib());
        profile.setAcceptUntrustedCertificates(firefoxProperties.shouldAcceptUntrustedCerts());
        profile.setAssumeUntrustedCertificateIssuer(firefoxProperties.shouldUntrustedCertIssuer());
        return profile;
    }

    static enum WebDriverType {
        CHROME(new String[]{"chrome", "googlechrome"}){

            @Override
            public WebDriver create(WebDriverFactory webDriverFactory, DesiredCapabilities desiredCapabilities) {
                ChromeDriverServiceProperties serviceProperties = webDriverFactory.driverServices == null ? null : webDriverFactory.driverServices.getChrome();
                DriverService driverService = serviceProperties == null ? null : serviceProperties.getDriverService();
                return driverService == null ? new ChromeDriver((Capabilities)desiredCapabilities) : new RemoteWebDriver(driverService.getUrl(), (Capabilities)desiredCapabilities);
            }
        }
        ,
        FIREFOX(new String[]{"firefox"}){

            @Override
            public WebDriver create(WebDriverFactory webDriverFactory, DesiredCapabilities desiredCapabilities) {
                FirefoxDriverServiceProperties serviceProperties = webDriverFactory.driverServices == null ? null : webDriverFactory.driverServices.getFirefox();
                DriverService driverService = serviceProperties == null ? null : serviceProperties.getDriverService();
                return driverService == null ? new FirefoxDriver((Capabilities)desiredCapabilities) : new RemoteWebDriver(driverService.getUrl(), (Capabilities)desiredCapabilities);
            }
        }
        ,
        IE(new String[]{"internet explorer", "iexplore"}){

            @Override
            public WebDriver create(WebDriverFactory webDriverFactory, DesiredCapabilities desiredCapabilities) {
                InternetExplorerDriverServiceProperties serviceProperties = webDriverFactory.driverServices == null ? null : webDriverFactory.driverServices.getInternetExplorer();
                DriverService driverService = serviceProperties == null ? null : serviceProperties.getDriverService();
                return driverService == null ? new InternetExplorerDriver((Capabilities)desiredCapabilities) : new RemoteWebDriver(driverService.getUrl(), (Capabilities)desiredCapabilities);
            }
        }
        ,
        SAFARI(new String[]{"safari"}){

            @Override
            public WebDriver create(WebDriverFactory webDriverFactory, DesiredCapabilities desiredCapabilities) {
                return new SafariDriver((Capabilities)desiredCapabilities);
            }
        }
        ,
        PHANTOMJS(new String[]{"phantomjs"}){

            @Override
            public WebDriver create(WebDriverFactory webDriverFactory, DesiredCapabilities desiredCapabilities) {
                PhantomJsDriverServiceProperties serviceProperties = webDriverFactory.driverServices == null ? null : webDriverFactory.driverServices.getPhantomJs();
                DriverService driverService = serviceProperties == null ? null : serviceProperties.getDriverService();
                return driverService == null ? new PhantomJSDriver((Capabilities)desiredCapabilities) : new RemoteWebDriver(driverService.getUrl(), (Capabilities)desiredCapabilities);
            }
        };

        private Set<String> types = Sets.newHashSet();

        private WebDriverType(String ... types) {
            for (String type : types) {
                this.types.add(type.toLowerCase());
            }
        }

        public abstract WebDriver create(WebDriverFactory var1, DesiredCapabilities var2);

        public static WebDriverType typeFor(String value) {
            value = value.toLowerCase();
            for (WebDriverType type : WebDriverType.values()) {
                if (!type.types.contains(value)) continue;
                return type;
            }
            throw new IllegalArgumentException(String.format("Type %s is not valid", value));
        }
    }

    public static interface WebDriverTransformer {
        public WebDriver transform(WebDriver var1);
    }
}

