/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.data;

import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import minium.cucumber.data.ProfilesMatrix;

public class ExecutionProgress {
    private ProfilesMatrix profilesMatrix = new ProfilesMatrix("");
    private float progressInPercentage;
    private int numberOfProfiles;
    private int numberOfExecutedProfiles = -1;
    private Feature currentFeature;
    private int numberOfFeatures;
    private int numberOfExecutedFeatures;
    private Scenario currentScenario;
    private int numberOfScenarios;
    private int numberOfExecutedScenarios;
    private int totalNumberOfFailedScenarios;
    private float totalNumberOfExecutedScenarios;
    private long startTimestamp;

    private void updatePercentageOfProgress() {
        this.totalNumberOfExecutedScenarios = this.numberOfExecutedProfiles * this.numberOfScenarios + this.numberOfExecutedScenarios;
        float racio = this.totalNumberOfExecutedScenarios / (float)(this.numberOfProfiles * this.numberOfScenarios);
        this.progressInPercentage = racio * 100.0f;
    }

    public void startedNextProfile() {
        if (this.numberOfExecutedProfiles == -1) {
            this.startTimestamp = System.currentTimeMillis();
        }
        ++this.numberOfExecutedProfiles;
        this.numberOfExecutedFeatures = -1;
        this.numberOfExecutedScenarios = 0;
    }

    public void startedFeature(Feature feature) {
        this.currentFeature = feature;
        ++this.numberOfExecutedFeatures;
    }

    public void startedScenario(Scenario scenario) {
        this.currentScenario = scenario;
    }

    public void finishedScenario(Scenario scenario) {
        ++this.numberOfExecutedScenarios;
        this.updatePercentageOfProgress();
    }

    public void addFailedScenario() {
        ++this.totalNumberOfFailedScenarios;
    }

    public void setProfilesMatrix(ProfilesMatrix profilesMatrix) {
        this.profilesMatrix = profilesMatrix;
        this.numberOfProfiles = profilesMatrix.getMatrix().size();
    }

    public void setNumberOfFeatures(int numberOfFeatures) {
        this.numberOfFeatures = numberOfFeatures;
    }

    public void setNumberOfScenarios(int numberOfScenarios) {
        this.numberOfScenarios = numberOfScenarios;
    }

    public String[] getCurrentProfiles() {
        if (this.profilesMatrix.getMatrix().size() == 0) {
            return new String[0];
        }
        return this.profilesMatrix.getMatrix().get(this.numberOfExecutedProfiles);
    }

    public Feature getCurrentFeature() {
        return this.currentFeature;
    }

    public Scenario getCurrentScenario() {
        return this.currentScenario;
    }

    public float getProgressInPercentage() {
        return this.progressInPercentage;
    }

    public int getNumberOfProfiles() {
        return this.numberOfProfiles;
    }

    public int getNumberOfExecutedProfiles() {
        return this.numberOfExecutedProfiles;
    }

    public int getNumberOfFeatures() {
        return this.numberOfFeatures;
    }

    public int getNumberOfExecutedFeatures() {
        return this.numberOfExecutedFeatures;
    }

    public int getNumberOfScenarios() {
        return this.numberOfScenarios;
    }

    public int getNumberOfExecutedScenarios() {
        return this.numberOfExecutedScenarios;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public int getTotalNumberOfFailedScenarios() {
        return this.totalNumberOfFailedScenarios;
    }

    public void setTotalNumberOfFailedScenarios(int totalNumberOfFailedScenarios) {
        this.totalNumberOfFailedScenarios = totalNumberOfFailedScenarios;
    }

    public float getTotalNumberOfExecutedScenarios() {
        return this.totalNumberOfExecutedScenarios;
    }

    public void setTotalNumberOfExecutedScenarios(float totalNumberOfExecutedScenarios) {
        this.totalNumberOfExecutedScenarios = totalNumberOfExecutedScenarios;
    }
}

