/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Throwables;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractThrowableAssert<S extends AbstractThrowableAssert<S, A>, A extends Throwable>
extends AbstractObjectAssert<S, A> {
    @VisibleForTesting
    Throwables throwables = Throwables.instance();

    public AbstractThrowableAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected S hasBeenThrown() {
        if (this.actual == null) {
            throw Failures.instance().failure("Expecting code to raise a throwable.");
        }
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasMessage(String message) {
        this.throwables.assertHasMessage(this.info, (Throwable)this.actual, message);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasMessage(String message, Object ... parameters) {
        return this.hasMessage(String.format(message, parameters));
    }

    public S hasCause(Throwable cause) {
        this.throwables.assertHasCause(this.info, (Throwable)this.actual, cause);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasNoCause() {
        this.throwables.assertHasNoCause(this.info, (Throwable)this.actual);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasMessageStartingWith(String description) {
        this.throwables.assertHasMessageStartingWith(this.info, (Throwable)this.actual, description);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasMessageContaining(String description) {
        this.throwables.assertHasMessageContaining(this.info, (Throwable)this.actual, description);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasStackTraceContaining(String description) {
        this.throwables.assertHasStackTraceContaining(this.info, (Throwable)this.actual, description);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasMessageMatching(String regex) {
        this.throwables.assertHasMessageMatching(this.info, (Throwable)this.actual, regex);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasMessageEndingWith(String description) {
        this.throwables.assertHasMessageEndingWith(this.info, (Throwable)this.actual, description);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasCauseInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasCauseInstanceOf(this.info, (Throwable)this.actual, type);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasCauseExactlyInstanceOf(this.info, (Throwable)this.actual, type);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasRootCauseInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasRootCauseInstanceOf(this.info, (Throwable)this.actual, type);
        return (S)((AbstractThrowableAssert)this.myself);
    }

    public S hasRootCauseExactlyInstanceOf(Class<? extends Throwable> type) {
        this.throwables.assertHasRootCauseExactlyInstanceOf(this.info, (Throwable)this.actual, type);
        return (S)((AbstractThrowableAssert)this.myself);
    }
}

