/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.NodeList;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f), @WebBrowser(value=BrowserName.IE), @WebBrowser(value=BrowserName.EDGE)})
public class HTMLAllCollection
extends HTMLCollection {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f), @WebBrowser(value=BrowserName.EDGE)})
    public HTMLAllCollection() {
    }

    public HTMLAllCollection(DomNode parentScope) {
        super(parentScope, false);
    }

    @Override
    @JsxFunction
    public Object item(Object index) {
        BrowserVersion browser;
        Double numb;
        if (index instanceof String) {
            String name = (String)index;
            Object result = this.namedItem(name);
            if (null != result && Undefined.instance != result) {
                return result;
            }
            numb = Double.NaN;
            browser = this.getBrowserVersion();
            if (!browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CONVERT_STRINGS_TO_NUMBER)) {
                numb = ScriptRuntime.toNumber((Object)index);
            }
            if (ScriptRuntime.NaN == numb || numb.isNaN()) {
                return HTMLAllCollection.itemNotFound(browser);
            }
        } else {
            numb = ScriptRuntime.toNumber((Object)index);
            browser = this.getBrowserVersion();
        }
        if (!browser.hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_ITEM_FUNCT_SUPPORTS_DOUBLE_INDEX_ALSO) && (Double.isInfinite(numb) || numb != Math.floor(numb))) {
            return HTMLAllCollection.itemNotFound(browser);
        }
        Object object = this.get(numb.intValue(), (Scriptable)this);
        if (object == NOT_FOUND) {
            if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CHECK_NAME) && index instanceof Number && numb >= 0.0) {
                return null;
            }
            return HTMLAllCollection.itemNotFound(browser);
        }
        return object;
    }

    private static Object itemNotFound(BrowserVersion browser) {
        if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NULL_IF_ITEM_NOT_FOUND)) {
            return null;
        }
        return Undefined.instance;
    }

    @Override
    protected boolean isGetWithPreemptionSearchName() {
        return !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CHECK_NAME);
    }

    @Override
    @JsxFunction
    public final Object namedItem(String name) {
        DomElement elem;
        List<Object> elements = this.getElements();
        ArrayList<DomElement> matching = new ArrayList<DomElement>();
        BrowserVersion browser = this.getBrowserVersion();
        boolean idFirst = browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CHECK_NAME);
        if (idFirst) {
            for (Object next : elements) {
                if (!(next instanceof DomElement) || !name.equals((elem = (DomElement)next).getId())) continue;
                matching.add(elem);
            }
        }
        for (Object next : elements) {
            if (!(next instanceof DomElement)) continue;
            elem = (DomElement)next;
            if ((!idFirst || elem instanceof HtmlForm) && name.equals(elem.getAttribute("name"))) {
                matching.add(elem);
                continue;
            }
            if (idFirst || !name.equals(elem.getId())) continue;
            matching.add(elem);
        }
        if (matching.size() == 1 || matching.size() > 1 && browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NO_COLLECTION_FOR_MANY_HITS)) {
            return this.getScriptableForElement(matching.get(0));
        }
        if (matching.isEmpty()) {
            if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_NULL_IF_NAMED_ITEM_NOT_FOUND)) {
                return null;
            }
            return Undefined.instance;
        }
        DomNode domNode = this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(domNode, matching);
        collection.setAvoidObjectDetection(true);
        return collection;
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        BrowserVersion browser = this.getBrowserVersion();
        if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_SUPPORT_PARANTHESES)) {
            if (args.length == 0) {
                throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
            }
            if (args[0] instanceof Number) {
                return null;
            }
        }
        boolean nullIfNotFound = false;
        if (browser.hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_INTEGER_INDEX)) {
            if (args[0] instanceof Number) {
                double val = ((Number)args[0]).doubleValue();
                if (val != (double)((int)val)) {
                    return Undefined.instance;
                }
                if (val >= 0.0) {
                    nullIfNotFound = true;
                }
            } else {
                String val = Context.toString((Object)args[0]);
                try {
                    args[0] = Integer.parseInt(val);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        Object value = super.call(cx, scope, thisObj, args);
        if (nullIfNotFound && value == Undefined.instance) {
            return null;
        }
        return value;
    }

    @Override
    protected boolean supportsParanteses() {
        return true;
    }

    @Override
    protected AbstractList create(DomNode parentScope, List<?> initialElements) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLALLCOLLECTION_DO_NOT_CHECK_NAME)) {
            return new NodeList(parentScope, initialElements);
        }
        return super.create(parentScope, initialElements);
    }
}

