/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest;

import cucumber.runtime.Backend;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import minium.cucumber.rest.BackendContext;
import minium.cucumber.rest.BackendRegistry;
import minium.cucumber.rest.dto.ExecutionResult;
import minium.cucumber.rest.dto.GlueDTO;
import minium.cucumber.rest.dto.HookExecutionResult;
import minium.cucumber.rest.dto.ScenarioDTO;
import minium.cucumber.rest.dto.SnippetRequestDTO;
import minium.cucumber.rest.dto.StepDTO;
import minium.cucumber.rest.dto.StepDefinitionInvocation;
import minium.cucumber.rest.dto.StepMatchDTO;
import minium.cucumber.rest.dto.TagDTO;
import minium.cucumber.rest.dto.WorldDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cucumber"})
public class CucumberRestController {
    public static final String DEFAULT_BACKEND = "default";
    Map<String, BackendContext> backendContexts = new HashMap<String, BackendContext>();

    public CucumberRestController(Backend backend) {
        this(new BackendRegistry().register(DEFAULT_BACKEND, backend));
    }

    @Autowired
    public CucumberRestController(BackendRegistry backends) {
        for (Map.Entry<String, Backend> entry : backends.getAll().entrySet()) {
            this.backendContexts.put(entry.getKey(), new BackendContext(entry.getKey(), entry.getValue()));
        }
    }

    @RequestMapping(value={"/backends/{backendId}/glues"}, method={RequestMethod.GET})
    public List<GlueDTO> getGlues(@PathVariable String backendId) {
        return this.backendContext(backendId).getGlues();
    }

    @RequestMapping(value={"/backends/{backendId}/glues"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public GlueDTO createGlue(@PathVariable String backendId, String ... paths) {
        return this.backendContext(backendId).createGlue(paths);
    }

    @RequestMapping(value={"/backends/{backendId}/glues/{uuid}"}, method={RequestMethod.DELETE})
    public void deleteGlue(@PathVariable String backendId, UUID uuid) {
        this.backendContext(backendId).deleteGlue(uuid);
    }

    @RequestMapping(value={"/backends/{backendId}/worlds"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public WorldDTO createWorld(@PathVariable String backendId) {
        return this.backendContext(backendId).createWorld();
    }

    @RequestMapping(value={"/backends/{backendId}/worlds/{uuid}"}, method={RequestMethod.DELETE})
    public void deleteWorld(@PathVariable String backendId, @PathVariable UUID uuid) {
        this.backendContext(backendId).deleteWorld(uuid);
    }

    @RequestMapping(value={"/backends/{backendId}/glues/{uuid}/hookDefinitions/{id}/execution"}, method={RequestMethod.POST})
    public HookExecutionResult execute(@PathVariable String backendId, @PathVariable UUID uuid, @PathVariable long id, @RequestBody ScenarioDTO scenario) throws Throwable {
        return this.backendContext(backendId).execute(uuid, id, scenario);
    }

    @RequestMapping(value={"/backends/{backendId}/glues/{uuid}/hookDefinitions/{id}/matches"}, method={RequestMethod.POST})
    public boolean matches(@PathVariable String backendId, @PathVariable UUID uuid, @PathVariable long id, @RequestBody List<TagDTO> tags) {
        return this.backendContext(backendId).matches(uuid, id, tags);
    }

    @RequestMapping(value={"/backends/{backendId}/glues/{uuid}/stepDefinitions/{id}/execution"}, method={RequestMethod.POST})
    public ExecutionResult execute(@PathVariable String backendId, @PathVariable UUID uuid, @PathVariable long id, @RequestBody StepDefinitionInvocation stepDefinitionInvocation) throws Throwable {
        return this.backendContext(backendId).execute(uuid, id, stepDefinitionInvocation);
    }

    @RequestMapping(value={"/backends/{backendId}/glues/{uuid}/stepDefinitions/{id}/matchedArguments"}, method={RequestMethod.POST})
    public StepMatchDTO matchedArguments(@PathVariable String backendId, @PathVariable UUID uuid, @PathVariable long id, @RequestBody StepDTO step) throws Throwable {
        return this.backendContext(backendId).matchedArguments(uuid, id, step);
    }

    @RequestMapping(value={"/backends/{backendId}/snippet"}, method={RequestMethod.POST})
    public String getSnippet(@PathVariable String backendId, @RequestBody SnippetRequestDTO snippetRequest) {
        return this.backendContext(backendId).getSnippet(snippetRequest.getStep(), snippetRequest.getType());
    }

    private BackendContext backendContext(String backendId) {
        return this.backendContexts.get(backendId);
    }
}

