/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ConstrainedParameter
extends AbstractConstrainedElement {
    private final Type type;
    private final String name;
    private final int index;
    private final Set<MetaConstraint<?>> typeArgumentsConstraints;

    public ConstrainedParameter(ConfigurationSource source, ConstraintLocation location, Type type, int index, String name) {
        this(source, location, type, index, name, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), false, UnwrapMode.AUTOMATIC);
    }

    public ConstrainedParameter(ConfigurationSource source, ConstraintLocation location, Type type, int index, String name, Set<MetaConstraint<?>> constraints, Set<MetaConstraint<?>> typeArgumentsConstraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading, UnwrapMode unwrapMode) {
        super(source, ConstrainedElement.ConstrainedElementKind.PARAMETER, location, constraints, groupConversions, isCascading, unwrapMode);
        this.type = type;
        this.name = name;
        this.index = index;
        this.typeArgumentsConstraints = typeArgumentsConstraints != null ? Collections.unmodifiableSet(typeArgumentsConstraints) : Collections.emptySet();
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public Set<MetaConstraint<?>> getTypeArgumentsConstraints() {
        return this.typeArgumentsConstraints;
    }

    public ConstrainedParameter merge(ConstrainedParameter other) {
        ConfigurationSource mergedSource = ConfigurationSource.max(this.source, other.source);
        String mergedName = this.source.getPriority() > other.source.getPriority() ? this.name : other.name;
        UnwrapMode mergedUnwrapMode = this.source.getPriority() > other.source.getPriority() ? this.unwrapMode : other.unwrapMode;
        HashSet<MetaConstraint<?>> mergedConstraints = CollectionHelper.newHashSet(this.constraints);
        mergedConstraints.addAll(other.constraints);
        HashSet<MetaConstraint<?>> mergedTypeArgumentsConstraints = CollectionHelper.newHashSet(this.typeArgumentsConstraints);
        mergedTypeArgumentsConstraints.addAll(other.typeArgumentsConstraints);
        HashMap<Class<?>, Class<?>> mergedGroupConversions = CollectionHelper.newHashMap(this.groupConversions);
        mergedGroupConversions.putAll(other.groupConversions);
        return new ConstrainedParameter(mergedSource, this.getLocation(), this.type, this.index, mergedName, mergedConstraints, mergedTypeArgumentsConstraints, mergedGroupConversions, this.isCascading || other.isCascading, mergedUnwrapMode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MetaConstraint<?> oneConstraint : this.getConstraints()) {
            sb.append(oneConstraint.getDescriptor().getAnnotation().annotationType().getSimpleName());
            sb.append(", ");
        }
        String constraintsAsString = sb.length() > 0 ? sb.substring(0, sb.length() - 2) : sb.toString();
        return "ParameterMetaData [location=" + this.getLocation() + "], name=" + this.name + "], constraints=[" + constraintsAsString + "], isCascading=" + this.isCascading() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + (this.getLocation().getMember() == null ? 0 : this.getLocation().getMember().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstrainedParameter other = (ConstrainedParameter)obj;
        if (this.index != other.index) {
            return false;
        }
        return !(this.getLocation().getMember() == null ? other.getLocation().getMember() != null : !this.getLocation().getMember().equals(other.getLocation().getMember()));
    }
}

