/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import minium.BasicElements;
import minium.Elements;
import minium.FreezableElements;
import minium.IterableElements;
import minium.internal.DefaultIterableElements;
import minium.internal.ElementsFactory;
import minium.internal.HasElementsFactory;
import minium.internal.HasParent;
import minium.internal.InternalElementsFactory;
import minium.web.DelegatorWebDriver;
import minium.web.DocumentWebDriver;
import minium.web.TargetLocatorWebElements;
import minium.web.WebElements;
import minium.web.actions.HasBrowser;
import minium.web.internal.DefaultRoot;
import minium.web.internal.DefaultTargetLocatorWebElements;
import minium.web.internal.EmptyWebElements;
import minium.web.internal.ExpressionInvocationHandler;
import minium.web.internal.ExpressionWebElements;
import minium.web.internal.HasCoercer;
import minium.web.internal.HasExpressionizer;
import minium.web.internal.HasJavascriptInvoker;
import minium.web.internal.HasNativeWebDriver;
import minium.web.internal.InternalWebElements;
import minium.web.internal.NativeWebElements;
import minium.web.internal.WebElementFunctions;
import minium.web.internal.WebElementsFactory;
import minium.web.internal.actions.DefaultHasBrowser;
import minium.web.internal.actions.HasWebLocator;
import minium.web.internal.drivers.DefaultJavascriptInvoker;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.drivers.InternalDocumentWebDriver;
import minium.web.internal.drivers.WindowDelegatorWebDriver;
import minium.web.internal.drivers.WindowWebDriver;
import minium.web.internal.expression.Coercer;
import minium.web.internal.expression.ExpressionWebElementExpressionizer;
import minium.web.internal.expression.Expressionizer;
import minium.web.internal.expression.IdentityCoercer;
import minium.web.internal.expression.JsonCoercer;
import minium.web.internal.expression.JsonExpressionizer;
import minium.web.internal.expression.PrimitiveTypeCoercer;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import platypus.AbstractMixinInitializer;
import platypus.Mixin;
import platypus.MixinClass;
import platypus.MixinClasses;
import platypus.MixinInitializer;
import platypus.MixinInitializers;
import platypus.internal.Casts;

public class DefaultWebElementsFactory<T extends WebElements>
extends Mixin.Impl
implements WebElementsFactory<T>,
InternalElementsFactory<T> {
    private static final Class<?>[] CORE_INTFS = new Class[]{Elements.class, InternalWebElements.class, HasElementsFactory.class, HasNativeWebDriver.class, HasExpressionizer.class, HasWebLocator.class, HasBrowser.class, HasCoercer.class, ExpressionWebElements.class, TargetLocatorWebElements.class, FreezableElements.class, IterableElements.class};
    private final InternalDocumentWebDriver rootDocumentDriver;
    private Set<Class<?>> builerProvidedInterfaces;
    private final TypeToken<T> typeVariableToken = new TypeToken<T>(this.getClass()){};
    private final MixinClass<T> rootClass;
    private final MixinClass<T> hasParentClass;
    private final MixinInitializer baseInitializer;

    public DefaultWebElementsFactory(WebElementsFactory.Builder<T> builder) {
        final WebDriver webdriver = (WebDriver)Preconditions.checkNotNull((Object)builder.getWebDriver());
        this.rootDocumentDriver = webdriver instanceof InternalDocumentWebDriver ? (InternalDocumentWebDriver)webdriver : (webdriver instanceof DelegatorWebDriver ? new WindowDelegatorWebDriver((DelegatorWebDriver)webdriver) : new WindowWebDriver(webdriver));
        final DefaultJavascriptInvoker javascriptInvoker = new DefaultJavascriptInvoker(builder.getClassLoader(), builder.getJsResources(), builder.getCssResources());
        final Expressionizer.Composite expressionizer = new Expressionizer.Composite().add(new JsonExpressionizer(builder.getMapper())).add(new ExpressionWebElementExpressionizer()).addAll(builder.getAditionalExpressionizers());
        final Coercer.Composite coercer = new Coercer.Composite().add(new JsonCoercer(builder.getMapper())).add(new PrimitiveTypeCoercer()).add(new IdentityCoercer()).addAll(builder.getAditionalCoercers());
        final Class intf = (Class)Casts.unsafeCast((Object)this.typeVariableToken.getRawType());
        this.builerProvidedInterfaces = builder.getIntfs();
        MixinClasses.Builder mixinBuilder = MixinClasses.builder((Class)intf).addInterfaces((Class[])CORE_INTFS).addInterfaces(this.builerProvidedInterfaces);
        mixinBuilder.addInterfaces(new Class[]{HasJavascriptInvoker.class});
        this.rootClass = mixinBuilder.build();
        this.hasParentClass = mixinBuilder.addInterfaces(new Class[]{HasParent.class}).build();
        this.baseInitializer = MixinInitializers.combine((MixinInitializer[])new MixinInitializer[]{builder.getMixinInitializer(), new AbstractMixinInitializer(){

            protected void initialize() {
                this.implement(new Class[]{HasElementsFactory.class}).with((Object)new HasElementsFactory.Impl((ElementsFactory)DefaultWebElementsFactory.this));
                this.implement(new Class[]{HasNativeWebDriver.class}).with((Object)new HasNativeWebDriver.Impl(webdriver));
                this.implement(new Class[]{HasExpressionizer.class}).with((Object)new HasExpressionizer.Impl(expressionizer));
                this.implement(new Class[]{HasCoercer.class}).with((Object)new HasCoercer.Impl(coercer));
                this.implement(new Class[]{TargetLocatorWebElements.class}).with(new DefaultTargetLocatorWebElements());
                this.implement(new Class[]{IterableElements.class}).with((Object)new DefaultIterableElements());
                this.implement(new Class[]{HasJavascriptInvoker.class}).with((Object)new HasJavascriptInvoker.Impl(javascriptInvoker));
                this.implement(new Class[]{HasBrowser.class}).with(new DefaultHasBrowser());
                this.implement(new Class[]{HasWebLocator.class}).with(new HasWebLocator.Impl(intf, DefaultWebElementsFactory.this.builerProvidedInterfaces));
                ExpressionInvocationHandler expressionInvocationHandler = new ExpressionInvocationHandler(DefaultWebElementsFactory.this, coercer);
                for (Class intf2 : DefaultWebElementsFactory.this.builerProvidedInterfaces) {
                    this.implement(new Class[]{intf2}).with(expressionInvocationHandler);
                }
            }
        }});
    }

    public Set<Class<?>> getProvidedInterfaces() {
        return ImmutableSet.copyOf(this.builerProvidedInterfaces);
    }

    @Override
    public T createEmpty(DocumentWebDriver webDriver) {
        return (T)this.createMixin(new EmptyWebElements(webDriver));
    }

    @Override
    public T createNative(DocumentWebDriver webDriver, WebElement ... nativeWebElements) {
        return this.createNative(webDriver, Arrays.asList(nativeWebElements));
    }

    @Override
    public T createNative(DocumentWebDriver webDriver, Collection<WebElement> nativeWebElements) {
        return this.createNative((Collection<DocumentWebElement>)FluentIterable.from(nativeWebElements).transform(WebElementFunctions.wrap(webDriver)).toList());
    }

    @Override
    public T createNative(DocumentWebElement ... nativeWebElements) {
        return this.createNative(Arrays.asList(nativeWebElements));
    }

    @Override
    public T createNative(Collection<DocumentWebElement> nativeWebElements) {
        return (T)this.createMixin(new NativeWebElements(nativeWebElements));
    }

    public T createRoot() {
        return (T)this.createMixin(new DefaultRoot(this.rootDocumentDriver));
    }

    public T createMixin(final Elements elems) {
        AbstractMixinInitializer initializer = new AbstractMixinInitializer(){

            protected void initialize() {
                this.implement(new Class[]{Object.class}).with((Object)elems);
                this.implement(new Class[]{InternalWebElements.class}).with((Object)elems);
                this.implement(new Class[]{FreezableElements.class}).with((Object)elems);
                this.implement(new Class[]{ExpressionWebElements.class}).with((Object)elems);
                if (elems instanceof BasicElements) {
                    this.implement(new Class[]{BasicElements.class}).with((Object)elems);
                }
            }
        };
        return (T)((WebElements)this.rootClass.newInstance(MixinInitializers.combine((MixinInitializer[])new MixinInitializer[]{initializer, this.baseInitializer})));
    }

    public T createMixin(final Elements parent, final Elements elems) {
        AbstractMixinInitializer initializer = new AbstractMixinInitializer(){

            protected void initialize() {
                this.implement(new Class[]{Object.class}).with((Object)elems);
                this.implement(new Class[]{HasParent.class}).with((Object)new HasParent.Impl(parent));
                this.implement(new Class[]{InternalWebElements.class}).with((Object)elems);
                this.implement(new Class[]{FreezableElements.class}).with((Object)elems);
                this.implement(new Class[]{ExpressionWebElements.class}).with((Object)elems);
                if (elems instanceof BasicElements) {
                    this.override(new Class[]{BasicElements.class}).with((Object)elems);
                }
            }
        };
        return (T)((WebElements)this.hasParentClass.newInstance(MixinInitializers.combine((MixinInitializer[])new MixinInitializer[]{initializer, this.baseInitializer})));
    }
}

