/*
 * Decompiled with CFR 0.152.
 */
package minium;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.primitives.Ints;

public class Point {
    private final int x;
    private final int y;

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public Point moveBy(int xOffset, int yOffset) {
        return new Point(this.safeSum(this.x, xOffset), this.safeSum(this.y, yOffset));
    }

    public boolean isNull() {
        return this.x == 0 && this.y == 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        return other.x == this.x && other.y == this.y;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y});
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)Point.class.getSimpleName()).addValue(this.x).addValue(this.y).toString();
    }

    private int safeSum(int a, int b) {
        if ((a == Integer.MAX_VALUE || a == Integer.MIN_VALUE) && b != Integer.MAX_VALUE && b != Integer.MIN_VALUE) {
            return a;
        }
        if ((b == Integer.MAX_VALUE || b == Integer.MIN_VALUE) && a != Integer.MAX_VALUE && a != Integer.MIN_VALUE) {
            return b;
        }
        return Ints.saturatedCast((long)((long)a + (long)b));
    }
}

