/*
 * Decompiled with CFR 0.152.
 */
package minium.web.config.services;

import java.io.File;
import minium.web.config.services.ChromeDriverServiceProperties;
import minium.web.config.services.FirefoxDriverServiceProperties;
import minium.web.config.services.InternetExplorerDriverServiceProperties;
import minium.web.config.services.PhantomJsDriverServiceProperties;
import org.openqa.selenium.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Value;

public class DriverServicesProperties
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DriverServicesProperties.class);
    @Value(value="${app.home:.}")
    private File homedir;
    private ChromeDriverServiceProperties chrome;
    private FirefoxDriverServiceProperties firefox;
    private InternetExplorerDriverServiceProperties internetExplorer;
    private PhantomJsDriverServiceProperties phantomJs;

    public ChromeDriverServiceProperties getChrome() {
        File chromedriverExe;
        if (this.chrome == null && (chromedriverExe = this.findExecutable("chromedriver")) != null) {
            LOGGER.debug("Chrome driver found at {}", (Object)chromedriverExe.getAbsolutePath());
            this.chrome = new ChromeDriverServiceProperties();
            this.chrome.setDriverExecutable(chromedriverExe);
            this.chrome.setSilent(true);
        }
        return this.chrome;
    }

    public void setChrome(ChromeDriverServiceProperties chrome) {
        this.chrome = chrome;
    }

    public FirefoxDriverServiceProperties getFirefox() {
        File firefoxDriveExe;
        if (this.firefox == null && (firefoxDriveExe = this.findExecutable("geckodriver")) != null) {
            LOGGER.debug("Firefox driver found at {}", (Object)firefoxDriveExe.getAbsolutePath());
            this.firefox = new FirefoxDriverServiceProperties();
            this.firefox.setDriverExecutable(firefoxDriveExe);
        }
        return this.firefox;
    }

    public void setFirefox(FirefoxDriverServiceProperties firefox) {
        this.firefox = firefox;
    }

    public InternetExplorerDriverServiceProperties getInternetExplorer() {
        File ieDriverExe;
        if (this.internetExplorer == null && (ieDriverExe = this.findExecutable("IEDriverServer")) != null) {
            LOGGER.debug("IE driver server found at {}", (Object)ieDriverExe.getAbsolutePath());
            this.internetExplorer = new InternetExplorerDriverServiceProperties();
            this.internetExplorer.setDriverExecutable(ieDriverExe);
        }
        return this.internetExplorer;
    }

    public void setInternetExplorer(InternetExplorerDriverServiceProperties internetExplorer) {
        this.internetExplorer = internetExplorer;
    }

    public PhantomJsDriverServiceProperties getPhantomJs() {
        File phantomjsExe;
        if (this.phantomJs == null && (phantomjsExe = this.findExecutable("phantomjs")) != null) {
            LOGGER.debug("PhantomJS found at {}", (Object)phantomjsExe.getAbsolutePath());
            this.phantomJs = new PhantomJsDriverServiceProperties();
            this.phantomJs.setDriverExecutable(phantomjsExe);
        }
        return this.phantomJs;
    }

    public void setPhantomJs(PhantomJsDriverServiceProperties phamtomJs) {
        this.phantomJs = phamtomJs;
    }

    protected File findExecutable(String exeName) {
        File driversDir = this.getDriversDir();
        if (driversDir == null) {
            return null;
        }
        String osSpecificExeName = Platform.getCurrent().is(Platform.WINDOWS) ? exeName + ".exe" : exeName;
        File exeFile = new File(driversDir, osSpecificExeName);
        return exeFile.exists() && exeFile.isFile() && exeFile.canExecute() ? exeFile : null;
    }

    protected File getDriversDir() {
        File driverDir = this.homedir == null ? null : new File(this.homedir, "drivers");
        return driverDir != null && driverDir.exists() && driverDir.isDirectory() ? driverDir : null;
    }

    public void destroy() throws Exception {
        if (this.chrome != null) {
            this.chrome.destroy();
        }
        if (this.firefox != null) {
            this.firefox.destroy();
        }
        if (this.internetExplorer != null) {
            this.internetExplorer.destroy();
        }
        if (this.phantomJs != null) {
            this.phantomJs.destroy();
        }
    }
}

