/*
 * Decompiled with CFR 0.152.
 */
package minium.developer.fs.web.rest;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import minium.developer.fs.domain.AutoFormatter;
import minium.developer.fs.domain.FileContent;
import minium.developer.fs.domain.FileDTO;
import minium.developer.fs.domain.FileProps;
import minium.developer.fs.service.FileSystemService;
import minium.developer.fs.web.method.support.AntPath;
import minium.developer.fs.web.method.support.BaseURL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/app/rest/fs"})
public class FileSystemAccessResource {
    @Autowired(required=false)
    private List<AutoFormatter> autoFormatters = Lists.newArrayList();
    @Autowired
    private FileSystemService service;

    @RequestMapping(value={"/**"}, params={"action=props"}, method={RequestMethod.GET})
    @ResponseBody
    public FileProps getFileProps(@BaseURL String baseUrl, @AntPath(value="path") String path) throws IOException {
        return this.service.getFileProps(baseUrl, path);
    }

    @RequestMapping(value={"/**"}, params={"action=list"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<FileProps> list(@BaseURL String baseUrl, @AntPath(value="path") String path) throws IOException {
        return this.service.list(baseUrl, path);
    }

    @RequestMapping(value={"/**"}, params={"action=listAll"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<FileProps> listAll(@BaseURL String baseUrl, @AntPath(value="path") String path) throws IOException {
        return this.service.listAll(baseUrl, path);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.GET})
    @ResponseBody
    public FileContent getFileContent(@BaseURL String baseUrl, @AntPath(value="path") String path) throws IOException, URISyntaxException {
        return this.service.getFileContent(baseUrl, path);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@AntPath(value="path") String path) throws IOException {
        this.service.delete(path);
    }

    @RequestMapping(value={"/**"}, method={RequestMethod.POST})
    @ResponseBody
    public FileContent save(@BaseURL String baseUrl, @RequestBody FileContent fileContent) throws IOException {
        return this.service.save(baseUrl, fileContent);
    }

    @RequestMapping(value={"/**"}, params={"action=search", "q"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<FileProps> search(@BaseURL String baseUrl, @AntPath(value="path") String path, @RequestParam(value="q") String query) throws IOException {
        return this.service.search(baseUrl, path, query);
    }

    @RequestMapping(value={"/**"}, params={"action=searchContent", "q"}, method={RequestMethod.GET})
    @ResponseBody
    public Set<FileProps> searchContent(@BaseURL String baseUrl, @AntPath(value="path") String path, @RequestParam(value="q") String query) throws IOException {
        return this.service.searchContent(baseUrl, query);
    }

    @SendToUser(value={"/queue/errors"})
    public String handleException(Throwable exception) {
        return exception.getMessage();
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<FileProps> create(@BaseURL String baseUrl, @RequestBody String path) throws IOException, URISyntaxException {
        FileProps props = this.service.create(baseUrl, path);
        if (props == null) {
            return new ResponseEntity((Object)props, HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((Object)props, HttpStatus.OK);
    }

    @RequestMapping(value={"/new/folder"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<FileProps> createFolder(@BaseURL String baseUrl, @RequestBody String path) throws IOException, URISyntaxException {
        FileProps props = this.service.createFolder(baseUrl, path);
        if (props == null) {
            return new ResponseEntity((Object)props, HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((Object)props, HttpStatus.OK);
    }

    @RequestMapping(value={"/rename"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<FileProps> rename(@BaseURL String baseUrl, @RequestBody FileDTO fileDTO) throws IOException, URISyntaxException {
        FileProps props = this.service.renameFile(baseUrl, fileDTO);
        if (props == null) {
            return new ResponseEntity((Object)props, HttpStatus.PRECONDITION_FAILED);
        }
        return new ResponseEntity((Object)props, HttpStatus.OK);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.PUT})
    @ResponseBody
    public void delete(@BaseURL String baseUrl, @RequestBody String path) {
        try {
            this.service.delete(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/delete/directory"}, method={RequestMethod.PUT})
    @ResponseBody
    public void deleteDirectory(@BaseURL String baseUrl, @RequestBody String path) {
        try {
            this.service.deleteDirectory(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

