/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationInitializer;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class FlywayAutoConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    public StringOrNumberToMigrationVersionConverter stringOrNumberMigrationVersionConverter() {
        return new StringOrNumberToMigrationVersionConverter();
    }

    private static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        private StringOrNumberToMigrationVersionConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString((Object)source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class FlywayJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public FlywayJpaDependencyConfiguration() {
            super("flyway");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    public static class FlywayConfiguration {
        private final FlywayProperties properties;
        private final ResourceLoader resourceLoader;
        private final DataSource dataSource;
        private final DataSource flywayDataSource;
        private final FlywayMigrationStrategy migrationStrategy;

        public FlywayConfiguration(FlywayProperties properties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSourceProvider, @FlywayDataSource ObjectProvider<DataSource> flywayDataSourceProvider, ObjectProvider<FlywayMigrationStrategy> migrationStrategyProvider) {
            this.properties = properties;
            this.resourceLoader = resourceLoader;
            this.dataSource = (DataSource)dataSourceProvider.getIfUnique();
            this.flywayDataSource = (DataSource)flywayDataSourceProvider.getIfAvailable();
            this.migrationStrategy = (FlywayMigrationStrategy)migrationStrategyProvider.getIfAvailable();
        }

        @PostConstruct
        public void checkLocationExists() {
            if (this.properties.isCheckLocation()) {
                Assert.state((!this.properties.getLocations().isEmpty() ? 1 : 0) != 0, (String)"Migration script locations not configured");
                boolean exists = this.hasAtLeastOneLocation();
                Assert.state((boolean)exists, (String)("Cannot find migrations location in: " + this.properties.getLocations() + " (please add migrations or check your Flyway configuration)"));
            }
        }

        private boolean hasAtLeastOneLocation() {
            for (String location : this.properties.getLocations()) {
                if (!this.resourceLoader.getResource(location).exists()) continue;
                return true;
            }
            return false;
        }

        @Bean
        @ConfigurationProperties(prefix="flyway")
        public Flyway flyway() {
            Flyway flyway = new Flyway();
            if (this.properties.isCreateDataSource()) {
                flyway.setDataSource(this.properties.getUrl(), this.properties.getUser(), this.properties.getPassword(), this.properties.getInitSqls().toArray(new String[0]));
            } else if (this.flywayDataSource != null) {
                flyway.setDataSource(this.flywayDataSource);
            } else {
                flyway.setDataSource(this.dataSource);
            }
            flyway.setLocations(this.properties.getLocations().toArray(new String[0]));
            return flyway;
        }

        @Bean
        @ConditionalOnMissingBean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway) {
            return new FlywayMigrationInitializer(flyway, this.migrationStrategy);
        }

        @Configuration
        @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
        @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
        protected static class FlywayInitializerJpaDependencyConfiguration
        extends EntityManagerFactoryDependsOnPostProcessor {
            public FlywayInitializerJpaDependencyConfiguration() {
                super("flywayInitializer");
            }
        }
    }
}

