/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest;

import com.google.common.base.Preconditions;
import cucumber.api.Scenario;
import cucumber.api.SnippetType;
import cucumber.runtime.Backend;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.UnreportedStepExecutor;
import cucumber.runtime.snippets.FunctionNameGenerator;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minium.cucumber.rest.RemoteExecutionException;
import minium.cucumber.rest.RemoteHookDefinition;
import minium.cucumber.rest.RemoteStepDefinition;
import minium.cucumber.rest.dto.ArgumentDTO;
import minium.cucumber.rest.dto.ExecutionResult;
import minium.cucumber.rest.dto.GlueDTO;
import minium.cucumber.rest.dto.HookDefinitionDTO;
import minium.cucumber.rest.dto.HookExecutionResult;
import minium.cucumber.rest.dto.ScenarioDTO;
import minium.cucumber.rest.dto.SnippetRequestDTO;
import minium.cucumber.rest.dto.StepDTO;
import minium.cucumber.rest.dto.StepDefinitionDTO;
import minium.cucumber.rest.dto.StepDefinitionInvocation;
import minium.cucumber.rest.dto.StepExecutionResult;
import minium.cucumber.rest.dto.StepMatchDTO;
import minium.cucumber.rest.dto.TagDTO;
import minium.cucumber.rest.dto.WorldDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RemoteBackend
implements Backend {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteBackend.class);
    private static final String FUNCTION_NAME = "function name";
    private static final Map<String, SnippetType> snippetTypes = new HashMap<String, SnippetType>();
    private final String backendUrl;
    private final RestTemplate template;
    private WorldDTO world;

    public RemoteBackend(String baseUrl) {
        this(baseUrl, new RestTemplate());
    }

    public RemoteBackend(String baseUrl, RestTemplate template) {
        this.backendUrl = baseUrl;
        this.template = template;
    }

    public RestTemplate getTemplate() {
        return this.template;
    }

    public void loadGlue(Glue glue, List<String> gluePaths) {
        URI uri = this.uriBuilderFor("/glues").queryParam("path", gluePaths.toArray()).buildAndExpand(new Object[0]).toUri();
        GlueDTO remoteGlue = (GlueDTO)this.template.postForObject(uri, null, GlueDTO.class);
        for (HookDefinitionDTO hookDefinitionDTO : remoteGlue.getBeforeHooks()) {
            glue.addBeforeHook((HookDefinition)new RemoteHookDefinition(this, hookDefinitionDTO));
        }
        for (HookDefinitionDTO hookDefinitionDTO : remoteGlue.getAfterHooks()) {
            glue.addAfterHook((HookDefinition)new RemoteHookDefinition(this, hookDefinitionDTO));
        }
        for (StepDefinitionDTO stepDefinitionDTO : remoteGlue.getStepDefinitions()) {
            glue.addStepDefinition((StepDefinition)new RemoteStepDefinition(this, stepDefinitionDTO));
        }
    }

    public void setUnreportedStepExecutor(UnreportedStepExecutor executor) {
    }

    public void buildWorld() {
        if (this.world != null) {
            LOGGER.warn("A world with UUID {} already exists", (Object)this.world.getUuid());
        }
        URI uri = this.uriBuilderFor("/worlds").buildAndExpand(new Object[0]).toUri();
        this.world = (WorldDTO)this.template.postForObject(uri, null, WorldDTO.class);
    }

    public void disposeWorld() {
        if (this.world == null) {
            LOGGER.warn("No world exists");
        } else {
            URI uri = this.uriBuilderFor("/worlds/{uuid}").buildAndExpand(new Object[]{this.world.getUuid()}).toUri();
            this.template.delete(uri);
            this.world = null;
        }
    }

    public String getSnippet(Step step, FunctionNameGenerator nameGenerator) {
        SnippetType snippetType = this.getSnippetType(nameGenerator);
        URI uri = this.uriBuilderFor("/snippet").buildAndExpand(new Object[0]).toUri();
        SnippetRequestDTO snippetRequest = new SnippetRequestDTO(new StepDTO(step), snippetType);
        return (String)this.template.postForObject(uri, (Object)snippetRequest, String.class);
    }

    public void execute(HookDefinitionDTO hookDefinition, Scenario scenario) {
        ScenarioDTO remoteScenario = new ScenarioDTO(scenario);
        URI uri = this.uriBuilderFor("/glues/{uuid}/hookDefinitions/{id}/execution").buildAndExpand(new Object[]{hookDefinition.getGlueId(), hookDefinition.getId()}).toUri();
        HookExecutionResult execution = (HookExecutionResult)this.template.postForObject(uri, (Object)remoteScenario, HookExecutionResult.class);
        remoteScenario.populate(scenario);
        if (execution.getStatus() == ExecutionResult.Status.FAILED) {
            throw new RemoteExecutionException(execution.getException());
        }
    }

    public boolean matches(HookDefinitionDTO hookDefinition, Collection<Tag> tags) {
        URI uri = this.uriBuilderFor("/glues/{uuid}/hookDefinitions/{id}/matches").buildAndExpand(new Object[]{hookDefinition.getGlueId(), hookDefinition.getId()}).toUri();
        return (Boolean)this.template.postForObject(uri, this.toTagDTOs(tags), Boolean.class);
    }

    public void execute(StepDefinitionDTO stepDefinition, I18n i18n, Object[] args) {
        StepDefinitionInvocation stepDefinitionInvocation = new StepDefinitionInvocation(i18n, args);
        URI uri = this.uriBuilderFor("/glues/{uuid}/stepDefinitions/{id}/execution").buildAndExpand(new Object[]{stepDefinition.getGlueId(), stepDefinition.getId()}).toUri();
        StepExecutionResult execution = (StepExecutionResult)this.template.postForObject(uri, (Object)stepDefinitionInvocation, StepExecutionResult.class);
        if (execution.getStatus() == ExecutionResult.Status.FAILED) {
            throw new RemoteExecutionException(execution.getException());
        }
    }

    public SnippetType getSnippetType(FunctionNameGenerator nameGenerator) {
        String functionName = nameGenerator.generateFunctionName(FUNCTION_NAME);
        SnippetType snippetType = snippetTypes.get(functionName);
        return (SnippetType)Preconditions.checkNotNull((Object)snippetType, (String)"FunctionNameGenerator is not camel case or underscore (it generated %s)", (Object[])new Object[]{functionName});
    }

    public List<Argument> matchedArguments(StepDefinitionDTO stepDefinition, Step step) {
        StepDTO stepProxy = new StepDTO(step);
        URI uri = this.uriBuilderFor("/glues/{uuid}/stepDefinitions/{id}/matchedArguments").buildAndExpand(new Object[]{stepDefinition.getGlueId(), stepDefinition.getId()}).toUri();
        StepMatchDTO match = (StepMatchDTO)this.template.postForObject(uri, (Object)stepProxy, StepMatchDTO.class);
        return this.toGerkinArguments(match.getArguments());
    }

    protected UriComponentsBuilder uriBuilderFor(String path) {
        return UriComponentsBuilder.fromHttpUrl((String)(this.backendUrl + path));
    }

    protected List<Argument> toGerkinArguments(ArgumentDTO[] matchedArguments) {
        if (matchedArguments == null) {
            return null;
        }
        ArrayList<Argument> gherkinArgs = new ArrayList<Argument>();
        for (ArgumentDTO arg : matchedArguments) {
            gherkinArgs.add(arg.toArgument());
        }
        return gherkinArgs;
    }

    protected List<TagDTO> toTagDTOs(Collection<Tag> gherkinTags) {
        if (gherkinTags == null) {
            return null;
        }
        ArrayList<TagDTO> dtos = new ArrayList<TagDTO>();
        for (Tag gherkinTag : gherkinTags) {
            dtos.add(new TagDTO(gherkinTag));
        }
        return dtos;
    }

    static {
        snippetTypes.put(SnippetType.CAMELCASE.getFunctionNameGenerator().generateFunctionName(FUNCTION_NAME), SnippetType.CAMELCASE);
        snippetTypes.put(SnippetType.UNDERSCORE.getFunctionNameGenerator().generateFunctionName(FUNCTION_NAME), SnippetType.UNDERSCORE);
    }
}

