/*
 * Decompiled with CFR 0.152.
 */
package platypus;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import platypus.InstanceProvider;
import platypus.InstanceProviders;
import platypus.MixinImplementor;
import platypus.MixinInitializer;

public abstract class AbstractMixinInitializer
implements MixinInitializer {
    private MixinImplementor mixinImplementor;

    protected Implementation implement(Class<?> ... intfs) {
        return this.implement((Collection<Class<?>>)ImmutableSet.copyOf((Object[])intfs));
    }

    protected Implementation implement(Collection<Class<?>> intfs) {
        return new Implementation(intfs);
    }

    protected Implementation override(Class<?> ... intfs) {
        return this.override((Collection<Class<?>>)ImmutableSet.copyOf((Object[])intfs));
    }

    protected Implementation override(Collection<Class<?>> intfs) {
        return new OverrideImplementation(intfs);
    }

    protected Implementation implementRemainers() {
        return new RemainersImplementation();
    }

    protected abstract void initialize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initialize(MixinImplementor mixinImplementor) {
        Preconditions.checkState((this.mixinImplementor == null ? 1 : 0) != 0, (Object)"Re-entry is not allowed.");
        this.mixinImplementor = (MixinImplementor)Preconditions.checkNotNull((Object)mixinImplementor, (Object)"mixinImplementor");
        try {
            this.initialize();
        }
        finally {
            this.mixinImplementor = null;
        }
    }

    class RemainersImplementation
    extends Implementation {
        RemainersImplementation() {
        }

        @Override
        public MixinInitializer with(InstanceProvider<?> provider) {
            AbstractMixinInitializer.this.mixinImplementor.implementRemainers().with(provider);
            return AbstractMixinInitializer.this;
        }
    }

    public class OverrideImplementation
    extends Implementation {
        public OverrideImplementation(Collection<Class<?>> intfs) {
            super(intfs);
        }

        @Override
        public MixinInitializer with(InstanceProvider<?> provider) {
            Preconditions.checkState((AbstractMixinInitializer.this.mixinImplementor != null ? 1 : 0) != 0, (Object)"override(...).with(...) can only be called inside configure()!");
            AbstractMixinInitializer.this.mixinImplementor.override(this.intfs).with(provider);
            return AbstractMixinInitializer.this;
        }
    }

    public class Implementation {
        protected final Set<Class<?>> intfs;

        public Implementation() {
            this(Collections.emptyList());
        }

        public Implementation(Collection<Class<?>> intfs) {
            this.intfs = ImmutableSet.copyOf(intfs);
        }

        public MixinInitializer with(InstanceProvider<?> provider) {
            Preconditions.checkState((AbstractMixinInitializer.this.mixinImplementor != null ? 1 : 0) != 0, (Object)"implement(...).with(...) can only be called inside configure()!");
            AbstractMixinInitializer.this.mixinImplementor.implement(this.intfs).with(provider);
            return AbstractMixinInitializer.this;
        }

        public MixinInitializer with(Object instance) {
            return this.with(InstanceProviders.ofInstance(instance));
        }

        public MixinInitializer with(InvocationHandler handler) {
            return this.with(InstanceProviders.adapt(handler, this.intfs));
        }
    }
}

