/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.google.common.base.Defaults;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Primitives;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import minium.web.internal.expression.CannotCoerceException;
import minium.web.internal.expression.Coercer;

public class PrimitiveTypeCoercer
implements Coercer {
    static Map<Class<?>, Coercer> primitiveCoercers = Maps.newHashMap();

    @Override
    public boolean handles(Object obj, Type type) {
        return PrimitiveTypeCoercer.clazzFor(type).isPrimitive() || Primitives.isWrapperType(PrimitiveTypeCoercer.clazzFor(type));
    }

    @Override
    public Object coerce(Object obj, Type type) {
        if (obj == null) {
            return Defaults.defaultValue(PrimitiveTypeCoercer.clazzFor(type));
        }
        Class wrappedType = Primitives.wrap(PrimitiveTypeCoercer.clazzFor(type));
        Coercer coercer = primitiveCoercers.get(wrappedType);
        return coercer.coerce(obj, wrappedType);
    }

    protected static Class<?> clazzFor(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            Type[] bounds = ((TypeVariable)type).getBounds();
            Preconditions.checkArgument((bounds.length < 2 ? 1 : 0) != 0, (String)"TypeVariable bounds only supported with 0 or 1 bound, and this one has %s", (Object[])new Object[]{bounds.length});
            if (bounds.length == 0) {
                return Object.class;
            }
            return PrimitiveTypeCoercer.clazzFor(bounds[0]);
        }
        throw new IllegalArgumentException(String.format("type %s is not a class or parameterized type", type));
    }

    static {
        primitiveCoercers.put(Boolean.class, new BooleanCoercer());
        primitiveCoercers.put(Byte.class, new ByteCoercer());
        primitiveCoercers.put(Short.class, new ShortCoercer());
        primitiveCoercers.put(Integer.class, new IntCoercer());
        primitiveCoercers.put(Long.class, new LongCoercer());
        primitiveCoercers.put(Float.class, new FloatCoercer());
        primitiveCoercers.put(Double.class, new DoubleCoercer());
        primitiveCoercers.put(Character.class, new CharCoercer());
    }

    static class CharCoercer
    implements Coercer {
        CharCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Character.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1.0 : 0.0;
            }
            if (obj instanceof String && obj.toString().length() == 1) {
                return Character.valueOf(obj.toString().charAt(0));
            }
            if (obj instanceof Number) {
                return Character.valueOf((char)((Number)obj).intValue());
            }
            throw new CannotCoerceException("Cannot convert to char");
        }
    }

    static class DoubleCoercer
    implements Coercer {
        DoubleCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Double.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1.0 : 0.0;
            }
            if (obj instanceof String) {
                return Double.parseDouble(obj.toString());
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            throw new CannotCoerceException("Cannot convert to double");
        }
    }

    static class FloatCoercer
    implements Coercer {
        FloatCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Float.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return Float.valueOf((Boolean)obj != false ? 1.0f : 0.0f);
            }
            if (obj instanceof String) {
                return Float.valueOf(Float.parseFloat(obj.toString()));
            }
            if (obj instanceof Number) {
                return Float.valueOf(((Number)obj).floatValue());
            }
            throw new CannotCoerceException("Cannot convert to float");
        }
    }

    static class LongCoercer
    implements Coercer {
        LongCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Long.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1L : 0L;
            }
            if (obj instanceof String) {
                return Long.parseLong(obj.toString());
            }
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            throw new CannotCoerceException("Cannot convert to long");
        }
    }

    static class IntCoercer
    implements Coercer {
        IntCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Integer.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            if (obj instanceof String) {
                return Integer.parseInt(obj.toString());
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            throw new CannotCoerceException("Cannot convert to int");
        }
    }

    static class ShortCoercer
    implements Coercer {
        ShortCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Short.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            if (obj instanceof String) {
                return Short.parseShort(obj.toString());
            }
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            throw new CannotCoerceException("Cannot convert to short");
        }
    }

    static class ByteCoercer
    implements Coercer {
        ByteCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Byte.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return (Boolean)obj != false ? 1 : 0;
            }
            if (obj instanceof String) {
                return Byte.parseByte(obj.toString());
            }
            if (obj instanceof Number) {
                return ((Number)obj).byteValue();
            }
            throw new CannotCoerceException("Cannot convert to byte");
        }
    }

    static class BooleanCoercer
    implements Coercer {
        BooleanCoercer() {
        }

        @Override
        public boolean handles(Object obj, Type type) {
            return Primitives.unwrap(PrimitiveTypeCoercer.clazzFor(type)) == Boolean.TYPE;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            if (obj instanceof Boolean) {
                return obj;
            }
            if (obj instanceof String) {
                return Boolean.parseBoolean(obj.toString());
            }
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue() != 0.0;
            }
            return false;
        }
    }
}

