/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import minium.web.internal.expression.BasicExpression;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.Expressionizer;

public class JsonExpressionizer
implements Expressionizer {
    private final ObjectMapper mapper;

    public JsonExpressionizer() {
        this(null);
    }

    public JsonExpressionizer(ObjectMapper objectMapper) {
        this.mapper = objectMapper == null ? new ObjectMapper() : objectMapper;
    }

    @Override
    public boolean handles(Object obj) {
        return true;
    }

    @Override
    public Expression apply(Object obj) {
        try {
            String json = this.mapper.writeValueAsString(obj);
            return new BasicExpression(json);
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

