/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.formatter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import minium.cucumber.data.ExecutionProgress;
import minium.cucumber.internal.CucumberContext;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;

public class ProgressFormatter
implements Formatter,
Reporter {
    private final File outputFile;
    private ObjectMapper mapper = new ObjectMapper();
    private ExecutionProgress progress = CucumberContext.getCurrent().getProgress();
    private boolean isTheFirstFeature = true;

    public ProgressFormatter(File outputFile) {
        this.outputFile = outputFile;
    }

    public void feature(Feature feature) {
        if (this.isTheFirstFeature) {
            this.progress.startedNextProfile();
            this.isTheFirstFeature = false;
        }
        this.progress.startedFeature(feature);
    }

    public void scenario(Scenario scenario) {
        this.progress.startedScenario(scenario);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        try {
            this.progress.finishedScenario(scenario);
            FileUtils.writeStringToFile((File)this.outputFile, (String)this.mapper.writeValueAsString((Object)this.progress), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void close() {
    }

    public void uri(String uri) {
    }

    public void background(Background background) {
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void step(Step step) {
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
    }

    public void done() {
    }

    public void result(Result result) {
        if (result.getStatus().equals("failed")) {
            this.progress.addFailedScenario();
        }
    }

    public void before(Match match, Result result) {
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }
}

