/*
 * Decompiled with CFR 0.152.
 */
package minium.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.Method;
import minium.Elements;
import minium.FindElements;
import minium.internal.InternalLocator;
import platypus.MixinClass;
import platypus.MixinClasses;

public class Locator<T extends Elements> {
    private MixinClass<T> mixinClass;
    private transient Supplier<? extends T> rootSupplier;

    public Locator(T root, Class<T> intf, Class<?> ... others) {
        this(intf, others);
        this.setRoot(root);
    }

    public Locator(Class<T> intf, Class<?> ... others) {
        Preconditions.checkArgument((boolean)intf.isInterface(), (String)"class %s is not an interface", (Object[])new Object[]{intf});
        this.mixinClass = MixinClasses.builder(intf).addInterfaces((Class[])others).addInterfaces(new Class[]{InternalLocator.class}).build();
    }

    public Locator(T root) {
        this(root.getClass(), new Class[0]);
        this.setRoot(root);
    }

    public void setRoot(Supplier<? extends T> supplier) {
        this.rootSupplier = supplier;
    }

    public void setRoot(T root) {
        this.setRoot((T)Suppliers.ofInstance(root));
    }

    public T getRoot() {
        return (T)(this.rootSupplier == null ? null : (Elements)this.rootSupplier.get());
    }

    public MixinClass<T> getMixinClass() {
        return this.mixinClass;
    }

    public void release() {
        this.rootSupplier = null;
    }

    public T root() {
        return (T)((Elements)InternalLocator.MethodInvocationImpl.createInternalLocator(this, null));
    }

    public T selector(String selector) {
        return this.root().as(FindElements.class).find(selector);
    }

    protected T createFinder(Method method, Object ... args) {
        return (T)((Elements)InternalLocator.MethodInvocationImpl.createInternalLocator(this, null, method, args));
    }

    public String toString() {
        return "by";
    }
}

