/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.drivers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import minium.web.internal.drivers.BaseDocumentWebDriver;
import minium.web.internal.drivers.DocumentWebElement;
import minium.web.internal.drivers.InternalDocumentWebDriver;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameWebDriver
extends BaseDocumentWebDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameWebDriver.class);
    private final DocumentWebElement frameElem;

    public FrameWebDriver(DocumentWebElement frameElem) {
        super(FrameWebDriver.getNativeWebDriver(frameElem));
        this.frameElem = frameElem;
    }

    @Override
    public void ensureSwitch() {
        InternalDocumentWebDriver parentDocumentDriver = this.parentDocumentDriver();
        Preconditions.checkState((boolean)Objects.equal((Object)parentDocumentDriver, (Object)this.frameElem.getWrappedDriver()), (String)"Frame %s does not belongs to %s", (Object[])new Object[]{this.frameElem, parentDocumentDriver});
        parentDocumentDriver.ensureSwitch();
        WebElement nativeFrameElem = this.frameElem.getWrappedWebElement();
        this.webDriver.switchTo().frame(nativeFrameElem);
        LOGGER.trace("Switched to frame {}", (Object)this.frameElem);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)FrameWebDriver.class.getSimpleName()).addValue((Object)this.frameElem).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.frameElem});
    }

    @Override
    public boolean isClosed() {
        return this.parentDocumentDriver().isClosed();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == FrameWebDriver.class && this.equalFields((FrameWebDriver)obj);
    }

    protected boolean equalFields(FrameWebDriver obj) {
        return super.equalFields(obj) && Objects.equal((Object)obj.frameElem, (Object)this.frameElem);
    }

    protected InternalDocumentWebDriver parentDocumentDriver() {
        return (InternalDocumentWebDriver)this.frameElem.getWrappedDriver();
    }

    private static WebDriver getNativeWebDriver(DocumentWebElement frameElem) {
        return ((InternalDocumentWebDriver)frameElem.getWrappedDriver()).nativeWebDriver();
    }
}

