/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.drivers;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import minium.web.internal.ResourceException;
import minium.web.internal.compressor.Compressor;
import minium.web.internal.compressor.ResourceFunctions;
import minium.web.internal.drivers.JavascriptInvocationFailedException;
import minium.web.internal.drivers.JavascriptInvoker;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavascriptInvoker
implements JavascriptInvoker {
    private static final int CHUNK_SIZE = 49152;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJavascriptInvoker.class);
    private static final String CLOSURE_COMPRESSOR_CLASSNAME = "minium.web.internal.compressor.ClosureCompressor";
    private static final String CLOSURE_COMPILER_CLASSNAME = "com.google.javascript.jscomp.Compiler";
    private static final String ARGS_DECLARATION = "var args = Array.prototype.slice.call(arguments)";
    private static final String INTERNAL_TEMPLATES_PATH = "minium/web/internal/templates/";
    private static final String LOAD_JS_STYLES_TEMPLATE_PATH = "minium/web/internal/templates/load-js-styles.template";
    private static final String SET_MINIUM_VAR_TEMPLATE_PATH = "minium/web/internal/templates/set-minium-var.template";
    private static final String EVAL_EXPR_TEMPLATE_PATH = "minium/web/internal/templates/eval-expression.template";
    private static Compressor compressor;
    private final Collection<String> jsResources;
    private final Collection<String> cssResources;
    private String jsScripts;
    private final String styles;
    private final ClassLoader classLoader;
    private final String loadJsStylesTemplate;
    private final String setMiniumVarTemplate;
    private final String evalExpressionTemplate;

    public DefaultJavascriptInvoker(ClassLoader classLoader, Collection<String> jsResources, Collection<String> cssResources) {
        this.classLoader = classLoader;
        this.jsResources = jsResources;
        this.cssResources = cssResources;
        try {
            LOGGER.debug("DefaultJavascriptInvoker initialized with:");
            LOGGER.debug("  jsResources  : {}", jsResources);
            LOGGER.debug("  cssResources : {}", cssResources);
            this.jsScripts = compressor.compress(DefaultJavascriptInvoker.class.getClassLoader(), jsResources);
            this.styles = cssResources != null ? this.combineResources(cssResources) : null;
            this.loadJsStylesTemplate = this.getJsContent(LOAD_JS_STYLES_TEMPLATE_PATH);
            this.setMiniumVarTemplate = this.getJsContent(SET_MINIUM_VAR_TEMPLATE_PATH);
            this.evalExpressionTemplate = this.getJsContent(EVAL_EXPR_TEMPLATE_PATH);
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
    }

    @Override
    public <T> T invoke(JavascriptExecutor wd, String expression, Object ... args) {
        return this.doInvoke(wd, expression, args);
    }

    @Override
    public <T> T invokeExpression(JavascriptExecutor executor, String expression, Object ... args) {
        return this.invoke(executor, expression, args);
    }

    protected <T> T doInvoke(JavascriptExecutor wd, String expression, Object ... args) {
        try {
            Object[] fullArgs = this.createLightInvokerScriptArgs(expression, args);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("About to invoke light invoker: {}", fullArgs);
            }
            Object result = wd.executeScript(this.lightInvokerScript(), fullArgs);
            LOGGER.trace("result: {}", result);
            List<?> response = this.getValidResponse(result);
            ResponseType type = ResponseType.of((String)response.get(0));
            if (type == ResponseType.MINIUM_UNDEFINED) {
                block7: {
                    fullArgs = this.createFullInvokerScriptArgs(expression, args);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("About to invoke full invoker: {}", fullArgs);
                    }
                    try {
                        result = wd.executeScript(this.fullInvokerScript(), fullArgs);
                    }
                    catch (WebDriverException e) {
                        String message = e.getMessage();
                        if (!(e instanceof UnreachableBrowserException) && (message == null || !message.startsWith("ERROR Selenium Server stopped responding"))) break block7;
                        LOGGER.debug("Failed sending the whole scripts at once, trying to send them in chunks");
                        this.loadPartitionedScriptsAndStyles(wd);
                        fullArgs = this.createFullInvokerScriptArgsAfterPartitionedLoad(expression, args);
                        result = wd.executeScript(this.fullInvokerScript(), fullArgs);
                    }
                }
                LOGGER.trace("result: {}", result);
                response = this.getValidResponse(result);
                type = ResponseType.of((String)response.get(0));
            }
            return (T)this.extractValue(type, response);
        }
        catch (WebDriverException e) {
            throw new JavascriptInvocationFailedException(String.format("Failed invoking expression:\n", expression), e);
        }
    }

    protected void loadPartitionedScriptsAndStyles(JavascriptExecutor wd) {
        List jsChunks = Splitter.fixedLength((int)49152).splitToList((CharSequence)this.jsScripts);
        ImmutableList styleChunks = this.styles == null ? ImmutableList.of() : Splitter.fixedLength((int)49152).splitToList((CharSequence)this.styles);
        for (String jsChunk : jsChunks) {
            wd.executeScript(this.loadJsStylesScript(), new Object[]{jsChunk, ""});
        }
        for (String styleChunk : styleChunks) {
            wd.executeScript(this.loadJsStylesScript(), new Object[]{"", styleChunk});
        }
    }

    private Object extractValue(ResponseType type, List<?> response) {
        switch (type) {
            case MINIUM_UNDEFINED: {
                throw new IllegalStateException("Should not be here...");
            }
            case NULL: {
                return null;
            }
            case ARRAY: {
                return response.subList(1, response.size());
            }
        }
        return response.get(1);
    }

    protected List<?> getValidResponse(Object result) {
        List response;
        Preconditions.checkState((result instanceof List || result instanceof WebElement ? 1 : 0) != 0, (String)"Expected a list or webelement as response but got %s", (Object[])new Object[]{result});
        if (result instanceof WebElement) {
            response = ImmutableList.of((Object)"array", (Object)result);
        } else {
            response = (List)result;
            Preconditions.checkState((!response.isEmpty() ? 1 : 0) != 0, (Object)"Expected response list not to be empty");
            Object first = response.get(0);
            Preconditions.checkState((first instanceof String || first instanceof WebElement ? 1 : 0) != 0, (String)"Expected a string or webelement value in the first position of the list but got %s", (Object[])new Object[]{result});
        }
        return response;
    }

    protected Object[] createLightInvokerScriptArgs(String expr, Object ... args) {
        ArrayList fullArgs = Lists.newArrayList((Object[])new Object[]{expr});
        if (args != null && args.length > 0) {
            fullArgs.addAll(Arrays.asList(args));
        }
        return fullArgs.toArray(new Object[fullArgs.size()]);
    }

    protected Object[] createFullInvokerScriptArgs(String expr, Object ... args) {
        ArrayList fullArgs = Lists.newArrayList((Object[])new Object[]{this.jsScripts, this.styles, expr});
        if (args != null && args.length > 0) {
            fullArgs.addAll(Arrays.asList(args));
        }
        return fullArgs.toArray(new Object[fullArgs.size()]);
    }

    protected Object[] createFullInvokerScriptArgsAfterPartitionedLoad(String expr, Object ... args) {
        ArrayList fullArgs = Lists.newArrayList((Object[])new Object[]{"", "", expr});
        if (args != null && args.length > 0) {
            fullArgs.addAll(Arrays.asList(args));
        }
        return fullArgs.toArray(new Object[fullArgs.size()]);
    }

    protected String lightInvokerScript() {
        return Joiner.on((String)"; ").join((Object)ARGS_DECLARATION, (Object)this.evalExpressionTemplate, new Object[0]);
    }

    protected String loadJsStylesScript() {
        return Joiner.on((String)"; ").join((Object)ARGS_DECLARATION, (Object)this.loadJsStylesTemplate, new Object[0]);
    }

    protected String fullInvokerScript() {
        return Joiner.on((String)"; ").join((Object)ARGS_DECLARATION, (Object)this.loadJsStylesTemplate, new Object[]{this.setMiniumVarTemplate, this.evalExpressionTemplate});
    }

    protected Collection<String> getJsResources() {
        return this.jsResources;
    }

    protected Collection<String> getCssResources() {
        return this.cssResources;
    }

    protected String getJsContent(String filePath) {
        return ((String)ResourceFunctions.classpathFileToStringFunction(this.classLoader).apply((Object)filePath)).replaceAll("\r?\n", " ");
    }

    protected String combineResources(Collection<String> resources) {
        return Joiner.on((String)"\n\n").join((Iterable)Collections2.transform(resources, ResourceFunctions.classpathFileToStringFunction(this.classLoader)));
    }

    static {
        try {
            Class.forName(CLOSURE_COMPILER_CLASSNAME, false, DefaultJavascriptInvoker.class.getClassLoader());
            compressor = (Compressor)Class.forName(CLOSURE_COMPRESSOR_CLASSNAME).newInstance();
        }
        catch (Exception e) {
            LOGGER.info("Google Closure Compiler not found in classpath, javascript will not be compressed");
            compressor = Compressor.NULL;
        }
    }

    static enum ResponseType {
        MINIUM_UNDEFINED("minium-undefined"),
        NULL("null"),
        JSON("json"),
        ARRAY("array"),
        NUMBER("number"),
        STRING("string"),
        BOOLEAN("boolean"),
        EXCEPTION("exception");

        private String typeStr;

        private ResponseType(String typeStr) {
            this.typeStr = typeStr;
        }

        public static ResponseType of(String typeStr) {
            for (ResponseType type : ResponseType.values()) {
                if (!Objects.equal((Object)type.typeStr, (Object)typeStr)) continue;
                return type;
            }
            throw new IllegalArgumentException(String.format("Type %s is not valid", typeStr));
        }

        public String toString() {
            return this.typeStr;
        }
    }
}

