/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import com.google.common.base.Predicate;
import minium.Elements;
import minium.web.DocumentWebDriver;
import minium.web.internal.HasNativeWebDriver;
import minium.web.internal.InternalWebElements;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.WebDriver;

public class WebWaitPredicates {
    public static <T extends Elements> Predicate<T> forAlert() {
        return new Predicate<T>(){

            public boolean apply(T elems) {
                WebDriver nativeWebDriver = ((HasNativeWebDriver)elems.as(HasNativeWebDriver.class)).nativeWebDriver();
                try {
                    return nativeWebDriver.switchTo().alert() != null;
                }
                catch (NoAlertPresentException e) {
                    return false;
                }
            }
        };
    }

    public static <T extends Elements> Predicate<T> forClosedWindow() {
        return new Predicate<T>(){

            public boolean apply(T elems) {
                DocumentWebDriver webDriver = ((InternalWebElements)elems.as(InternalWebElements.class)).documentDriver();
                return webDriver.isClosed();
            }
        };
    }
}

