/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import minium.Elements;
import minium.actions.ExceptionHandler;
import minium.actions.internal.AfterFailInteractionEvent;
import minium.web.actions.OnUnhandledAlertInteractionListener;
import minium.web.internal.HasNativeWebDriver;
import minium.web.internal.actions.DefaultOnExceptionInteractionListener;
import org.openqa.selenium.Alert;
import org.openqa.selenium.UnhandledAlertException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOnUnhandledAlertInteractionListener
extends DefaultOnExceptionInteractionListener
implements OnUnhandledAlertInteractionListener,
ExceptionHandler {
    private static final Logger LOGGEER = LoggerFactory.getLogger(DefaultOnUnhandledAlertInteractionListener.class);

    public DefaultOnUnhandledAlertInteractionListener() {
        super(UnhandledAlertException.class);
    }

    @Override
    protected boolean handle(AfterFailInteractionEvent event) {
        return this.handle(event.getSource(), event.getException());
    }

    public boolean handle(Elements elems, Throwable e) {
        this.handleAlert(((HasNativeWebDriver)elems.as(HasNativeWebDriver.class)).nativeWebDriver().switchTo().alert());
        return true;
    }

    protected void handleAlert(Alert alert) {
        if (LOGGEER.isDebugEnabled()) {
            LOGGEER.debug("Accepting alert box with message: {}", (Object)alert.getText());
        }
        alert.accept();
    }

    @Override
    public OnUnhandledAlertInteractionListener accept() {
        return this;
    }

    @Override
    public OnUnhandledAlertInteractionListener dismiss() {
        return new DefaultOnUnhandledAlertInteractionListener(){

            @Override
            protected void handleAlert(Alert alert) {
                if (LOGGEER.isDebugEnabled()) {
                    LOGGEER.debug("Dismissing alert box with message: {}", (Object)alert.getText());
                }
                alert.dismiss();
            }
        };
    }
}

