/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import minium.actions.Configuration;
import minium.actions.HasConfiguration;
import minium.actions.HasInteractionListeners;
import minium.actions.KeyboardInteractable;
import minium.actions.MouseInteractable;
import minium.actions.WaitInteractable;
import minium.actions.debug.DebugInteractable;
import minium.actions.internal.DefaultConfiguration;
import minium.actions.internal.DefaultHasInteractionListeners;
import minium.actions.internal.DefaultWaitInteractable;
import minium.internal.LocatableElements;
import minium.web.ConditionalWebElements;
import minium.web.CoreWebElements;
import minium.web.PositionWebElements;
import minium.web.WebElements;
import minium.web.actions.HasAlert;
import minium.web.actions.WebInteractable;
import minium.web.internal.WebElementsFactory;
import minium.web.internal.WebModule;
import minium.web.internal.actions.DefaultDebugInteractable;
import minium.web.internal.actions.DefaultHasAlert;
import minium.web.internal.actions.DefaultKeyboardInteractable;
import minium.web.internal.actions.DefaultMouseInteractable;
import minium.web.internal.actions.DefaultWebInteractable;
import org.openqa.selenium.WebDriver;
import platypus.AbstractMixinInitializer;
import platypus.MixinInitializer;

public class WebModules {
    public static WebModule positionModule() {
        return new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.withJsResources("minium/web/internal/lib/jquery.min.js", "minium/web/internal/lib/jquery.position.js").implementingInterfaces(PositionWebElements.class);
            }

            public String toString() {
                return "WebModule[position]";
            }
        };
    }

    public static WebModule conditionalModule() {
        return new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.withJsResources("minium/web/internal/lib/jquery.min.js", "minium/web/internal/lib/jquery.conditional.js").implementingInterfaces(ConditionalWebElements.class);
            }

            public String toString() {
                return "WebModule[conditional]";
            }
        };
    }

    public static WebModule defaultModule(WebDriver wd) {
        return WebModules.combine(WebModules.baseModule(wd), WebModules.positionModule(), WebModules.conditionalModule(), WebModules.interactableModule());
    }

    public static WebModule baseModule(WebDriver wd) {
        return WebModules.baseModule(wd, CoreWebElements.DefaultWebElements.class);
    }

    public static WebModule baseModule(final WebDriver wd, final Class<? extends WebElements> intf) {
        WebModule baseModule = new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.withWebDriver(wd).withJsResources("minium/web/internal/lib/json2.min.js", "minium/web/internal/lib/jquery.min.js", "minium/web/internal/lib/jquery.eval.js", "minium/web/internal/lib/jquery.minium-exts.js", "minium/web/internal/lib/jquery.visibleText.js").implementingInterfaces(intf, LocatableElements.class, HasAlert.class).usingMixinConfigurer((MixinInitializer)new AbstractMixinInitializer(){

                    protected void initialize() {
                        this.implement(new Class[]{HasAlert.class}).with((Object)new DefaultHasAlert());
                    }
                });
            }

            public String toString() {
                return "WebModule[base]";
            }
        };
        return baseModule;
    }

    public static WebModule javascriptDelegatingInterfaceModule(final Class<?> intf) {
        Preconditions.checkArgument((boolean)intf.isInterface());
        return new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.implementingInterfaces(intf);
            }

            public String toString() {
                return "WebModule[javascript delegating]";
            }
        };
    }

    public static WebModule interactableModule() {
        DefaultConfiguration configuration = new DefaultConfiguration();
        return new WebModule((Configuration)configuration){
            final /* synthetic */ Configuration val$configuration;
            {
                this.val$configuration = configuration;
            }

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.implementingInterfaces(HasInteractionListeners.class, HasConfiguration.class, WaitInteractable.class, MouseInteractable.class, KeyboardInteractable.class, WebInteractable.class).usingMixinConfigurer((MixinInitializer)new AbstractMixinInitializer(){

                    protected void initialize() {
                        this.implement(new Class[]{HasInteractionListeners.class}).with((Object)new DefaultHasInteractionListeners());
                        this.implement(new Class[]{HasConfiguration.class}).with((Object)new HasConfiguration.Impl(val$configuration));
                        this.implement(new Class[]{WaitInteractable.class}).with((Object)new DefaultWaitInteractable());
                        this.implement(new Class[]{MouseInteractable.class}).with(new DefaultMouseInteractable());
                        this.implement(new Class[]{KeyboardInteractable.class}).with(new DefaultKeyboardInteractable());
                        this.implement(new Class[]{WebInteractable.class}).with(new DefaultWebInteractable());
                    }
                });
            }

            public String toString() {
                return "WebModule[interactable]";
            }
        };
    }

    public static WebModule debugModule() {
        return new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.implementingInterfaces(DebugInteractable.class).withJsResources("minium/web/internal/lib/jquery.min.js", "minium/web/internal/lib/jquery.highlight.js").usingMixinConfigurer((MixinInitializer)new AbstractMixinInitializer(){

                    protected void initialize() {
                        this.implement(new Class[]{DebugInteractable.class}).with(new DefaultDebugInteractable());
                    }
                });
            }

            public String toString() {
                return "WebModule[debug]";
            }
        };
    }

    public static WebModule combine(final Iterable<? extends WebModule> modules) {
        return new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                for (WebModule module : modules) {
                    module.configure(builder);
                }
            }

            public String toString() {
                return String.format("WebModule%s", Iterables.toString((Iterable)modules));
            }
        };
    }

    public static WebModule combine(WebModule ... modules) {
        return WebModules.combine((Iterable<? extends WebModule>)ImmutableList.copyOf((Object[])modules));
    }
}

