/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.servlet.Servlet;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnJava;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.thymeleaf.AbstractTemplateResolverConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.AbstractThymeleafViewResolverConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.ConditionalOnEnabledResourceChain;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.conditionalcomments.dialect.ConditionalCommentsDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.resourceresolver.SpringResourceResourceResolver;
import org.thymeleaf.spring4.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@EnableConfigurationProperties(value={ThymeleafProperties.class})
@ConditionalOnClass(value={SpringTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class ThymeleafAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication
    protected static class ThymeleafResourceHandlingConfig {
        protected ThymeleafResourceHandlingConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledResourceChain
        public ResourceUrlEncodingFilter resourceUrlEncodingFilter() {
            return new ResourceUrlEncodingFilter();
        }
    }

    @Configuration
    @ConditionalOnJava(value=ConditionalOnJava.JavaVersion.EIGHT)
    @ConditionalOnClass(value={Java8TimeDialect.class})
    protected static class ThymeleafJava8TimeDialect {
        protected ThymeleafJava8TimeDialect() {
        }

        @Bean
        @ConditionalOnMissingBean
        public Java8TimeDialect java8TimeDialect() {
            return new Java8TimeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringSecurityDialect.class})
    protected static class ThymeleafSecurityDialectConfiguration {
        protected ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringSecurityDialect securityDialect() {
            return new SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataAttributeDialect.class})
    protected static class DataAttributeDialectConfiguration {
        protected DataAttributeDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAttributeDialect dialect() {
            return new DataAttributeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"nz.net.ultraq.thymeleaf.LayoutDialect"})
    protected static class ThymeleafWebLayoutConfiguration {
        protected ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringTemplateEngine.class})
    protected static class ThymeleafDefaultConfiguration {
        private final Collection<ITemplateResolver> templateResolvers;
        private final Collection<IDialect> dialects;

        public ThymeleafDefaultConfiguration(Collection<ITemplateResolver> templateResolvers, ObjectProvider<Collection<IDialect>> dialectsProvider) {
            this.templateResolvers = templateResolvers;
            this.dialects = (Collection)dialectsProvider.getIfAvailable();
        }

        @Bean
        public SpringTemplateEngine templateEngine() {
            SpringTemplateEngine engine = new SpringTemplateEngine();
            for (ITemplateResolver templateResolver : this.templateResolvers) {
                engine.addTemplateResolver(templateResolver);
            }
            if (!CollectionUtils.isEmpty(this.dialects)) {
                for (IDialect dialect : this.dialects) {
                    engine.addDialect(dialect);
                }
            }
            return engine;
        }
    }

    @Configuration
    @ConditionalOnClass(name={"org.thymeleaf.templatemode.TemplateMode"})
    static class Thymeleaf3Configuration {
        Thymeleaf3Configuration() {
        }

        @Configuration
        @ConditionalOnClass(value={Servlet.class})
        @ConditionalOnWebApplication
        static class Thymeleaf3ViewResolverConfiguration
        extends AbstractThymeleafViewResolverConfiguration {
            Thymeleaf3ViewResolverConfiguration(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
                super(properties, templateEngine);
            }

            @Override
            protected void configureTemplateEngine(ThymeleafViewResolver resolver, SpringTemplateEngine templateEngine) {
                Method setTemplateEngine;
                try {
                    setTemplateEngine = ReflectionUtils.findMethod(resolver.getClass(), (String)"setTemplateEngine", (Class[])new Class[]{Class.forName("org.thymeleaf.ITemplateEngine", true, resolver.getClass().getClassLoader())});
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException(ex);
                }
                ReflectionUtils.invokeMethod((Method)setTemplateEngine, (Object)resolver, (Object[])new Object[]{templateEngine});
            }
        }

        @Configuration
        @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
        static class DefaultTemplateResolverConfiguration
        extends AbstractTemplateResolverConfiguration {
            DefaultTemplateResolverConfiguration(ThymeleafProperties properties, ApplicationContext applicationContext) {
                super(properties, applicationContext);
            }

            @Override
            @Bean
            public SpringResourceTemplateResolver defaultTemplateResolver() {
                SpringResourceTemplateResolver resolver = super.defaultTemplateResolver();
                Method setCheckExistence = ReflectionUtils.findMethod(resolver.getClass(), (String)"setCheckExistence", (Class[])new Class[]{Boolean.TYPE});
                ReflectionUtils.invokeMethod((Method)setCheckExistence, (Object)resolver, (Object[])new Object[]{this.getProperties().isCheckTemplate()});
                return resolver;
            }
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.thymeleaf.templatemode.TemplateMode"})
    static class Thymeleaf2Configuration {
        Thymeleaf2Configuration() {
        }

        @Configuration
        @ConditionalOnClass(value={ConditionalCommentsDialect.class})
        static class ThymeleafConditionalCommentsDialectConfiguration {
            ThymeleafConditionalCommentsDialectConfiguration() {
            }

            @Bean
            @ConditionalOnMissingBean
            public ConditionalCommentsDialect conditionalCommentsDialect() {
                return new ConditionalCommentsDialect();
            }
        }

        @Configuration
        @ConditionalOnClass(value={Servlet.class})
        @ConditionalOnWebApplication
        static class Thymeleaf2ViewResolverConfiguration
        extends AbstractThymeleafViewResolverConfiguration {
            Thymeleaf2ViewResolverConfiguration(ThymeleafProperties properties, SpringTemplateEngine templateEngine) {
                super(properties, templateEngine);
            }

            @Override
            protected void configureTemplateEngine(ThymeleafViewResolver resolver, SpringTemplateEngine templateEngine) {
                resolver.setTemplateEngine(templateEngine);
            }
        }

        @Configuration
        @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
        static class DefaultTemplateResolverConfiguration
        extends AbstractTemplateResolverConfiguration {
            DefaultTemplateResolverConfiguration(ThymeleafProperties properties, ApplicationContext applicationContext) {
                super(properties, applicationContext);
            }

            @Bean
            public SpringResourceResourceResolver thymeleafResourceResolver() {
                return new SpringResourceResourceResolver();
            }
        }
    }
}

