/*
 * Decompiled with CFR 0.152.
 */
package minium.automator.config;

import java.io.File;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class AutomatorProperties {
    @Option(name="-f", aliases={"--file"}, metaVar="FILE", usage="script file to run")
    private File file;
    @Option(name="-b", aliases={"--browser"}, metaVar="BROWSER", usage="browser where scripts will be executed against (supported values: chrome, ie, firefox, safari, opera, phantomjs)")
    private String browser = "chrome";
    @Option(name="-m", aliases={"--module-paths"}, metaVar="MODULE_PATHS")
    private String[] modulePaths;
    @Option(name="-d", aliases={"--dir"}, metaVar="DIR")
    private File dir;
    @Option(name="-h", aliases={"--help"}, usage="display this help and exit")
    private boolean help;
    @Option(name="-v", aliases={"--version"}, usage="show version")
    private boolean version;
    @Argument(metaVar="SCRIPT", usage="script instructions to run. if --file is passed, SCRIPT is always executed before, so you can set variables for script file execution")
    private String script;

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    public File getFile() {
        if (this.file == null && this.dir != null) {
            File file = new File(this.dir, "main.js");
            return file.exists() ? file : null;
        }
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public String[] getModulePaths() {
        if (this.modulePaths == null && this.dir != null) {
            String[] stringArray;
            File moduleDir = new File(this.dir, "modules");
            if (moduleDir.exists()) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = moduleDir.getAbsolutePath();
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        return this.modulePaths;
    }

    public void setModulePaths(String[] modulePaths) {
        this.modulePaths = modulePaths;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean isHelp() {
        return this.help;
    }

    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }
}

