/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.data.reader;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minium.cucumber.data.reader.DataDTO;
import minium.cucumber.data.reader.DataReader;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVDataReader
implements DataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVDataReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDTO readTable(InputStream inputStream) {
        InputStreamReader fileReader = null;
        CSVParser csvFileParser = null;
        CSVFormat csvFileFormat = CSVFormat.DEFAULT;
        DataDTO dataDTO = new DataDTO();
        try {
            fileReader = new InputStreamReader(inputStream);
            csvFileParser = new CSVParser((Reader)fileReader, csvFileFormat);
            List csvRecords = csvFileParser.getRecords();
            for (int i = 0; i < csvRecords.size(); ++i) {
                ArrayList lineValues = Lists.newArrayList();
                CSVRecord record = (CSVRecord)csvRecords.get(i);
                Iterator iterator = record.iterator();
                while (iterator.hasNext()) {
                    lineValues.add(iterator.next());
                }
                dataDTO.addLineValues(i, lineValues);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in CsvFileReader -  {}", (Object)e.getMessage());
        }
        finally {
            try {
                fileReader.close();
                csvFileParser.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error while closing fileReader/csvFileParser -  {}", (Object)e.getMessage());
            }
        }
        return dataDTO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataDTO readExamples(InputStream inputStream) {
        InputStreamReader fileReader = null;
        CSVParser csvFileParser = null;
        CSVFormat csvFileFormat = CSVFormat.DEFAULT;
        DataDTO dataDTO = new DataDTO();
        try {
            fileReader = new InputStreamReader(inputStream);
            csvFileParser = new CSVParser((Reader)fileReader, csvFileFormat);
            List csvRecords = csvFileParser.getRecords();
            if (!csvRecords.isEmpty()) {
                ArrayList header = Lists.newArrayList((Iterable)((Iterable)csvRecords.get(0)));
                dataDTO.setHeaders(header);
            }
            for (int i = 1; i < csvRecords.size(); ++i) {
                ArrayList lineValues = Lists.newArrayList();
                CSVRecord record = (CSVRecord)csvRecords.get(i);
                Iterator iterator = record.iterator();
                while (iterator.hasNext()) {
                    lineValues.add(iterator.next());
                }
                dataDTO.addLineValues(i, lineValues);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in CsvFileReader -  {}", (Object)e.getMessage());
        }
        finally {
            try {
                fileReader.close();
                csvFileParser.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error while closing fileReader/csvFileParser -  {}", (Object)e.getMessage());
            }
        }
        return dataDTO;
    }
}

