/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.data;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cucumber.runtime.FeatureBuilder;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.PathWithLines;
import gherkin.formatter.PrettyFormatter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Comment;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import minium.cucumber.data.reader.DataDTO;
import minium.cucumber.data.reader.DataReader;
import minium.cucumber.data.reader.DataReaderFactory;
import org.springframework.core.io.FileSystemResource;

public class MiniumFeatureBuilder
extends FeatureBuilder {
    private PrettyFormatter prettyFormatter;
    private static final Pattern SOURCE_COMMENT_REGEX = Pattern.compile("#\\s*@source\\s*:(.*)");
    private Map<Integer, Integer> featureLineOffset;
    private File resourceDir;
    private File baseDir = new File("src/test/resources");
    private Integer lineOffset = 0;
    private boolean isPreview;

    public MiniumFeatureBuilder(List<CucumberFeature> cucumberFeatures, PrettyFormatter prettyFormatter, File resourceDir) {
        super(cucumberFeatures);
        this.prettyFormatter = prettyFormatter;
        this.resourceDir = resourceDir;
        this.featureLineOffset = Maps.newTreeMap();
        this.isPreview = false;
    }

    public MiniumFeatureBuilder(List<CucumberFeature> cucumberFeatures, File resourceDir) {
        super(cucumberFeatures);
        this.prettyFormatter = new PrettyFormatter((Appendable)new StringWriter(), true, false);
        this.resourceDir = resourceDir;
        this.featureLineOffset = Maps.newTreeMap();
        this.isPreview = false;
    }

    public MiniumFeatureBuilder(List<CucumberFeature> cucumberFeatures) {
        super(cucumberFeatures);
        this.prettyFormatter = new PrettyFormatter((Appendable)new StringWriter(), true, false);
        this.resourceDir = null;
        this.featureLineOffset = Maps.newTreeMap();
        this.isPreview = false;
    }

    public MiniumFeatureBuilder(List<CucumberFeature> cucumberFeatures, boolean isPreview) {
        super(cucumberFeatures);
        this.prettyFormatter = new PrettyFormatter((Appendable)new StringWriter(), true, false);
        this.resourceDir = null;
        this.isPreview = isPreview;
        this.featureLineOffset = Maps.newTreeMap();
    }

    public MiniumFeatureBuilder(List<CucumberFeature> cucumberFeatures, PrettyFormatter prettyFormatter, File resourceDir, boolean isPreview) {
        super(cucumberFeatures);
        this.prettyFormatter = prettyFormatter;
        this.resourceDir = resourceDir;
        this.isPreview = isPreview;
        this.featureLineOffset = Maps.newTreeMap();
    }

    public void uri(String uri) {
        super.uri(uri);
        this.prettyFormatter.uri(uri);
    }

    public void feature(Feature feature) {
        super.feature(feature);
        this.prettyFormatter.feature(feature);
    }

    public void background(Background background) {
        super.background(background);
        this.prettyFormatter.background(background);
    }

    public void scenario(Scenario scenario) {
        if (this.lineOffset != 0 && this.isPreview) {
            int newLine = scenario.getLine() + this.lineOffset;
            this.featureLineOffset.put(scenario.getLine(), newLine);
        }
        super.scenario(scenario);
        this.prettyFormatter.scenario(scenario);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        if (this.lineOffset != 0 && this.isPreview) {
            int newLine = scenarioOutline.getLine() + this.lineOffset;
            this.featureLineOffset.put(scenarioOutline.getLine(), newLine);
        }
        super.scenarioOutline(scenarioOutline);
        this.prettyFormatter.scenarioOutline(scenarioOutline);
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        super.startOfScenarioLifeCycle(scenario);
        this.prettyFormatter.startOfScenarioLifeCycle(scenario);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        super.endOfScenarioLifeCycle(scenario);
        this.prettyFormatter.endOfScenarioLifeCycle(scenario);
    }

    public void examples(Examples examples) {
        String filePathFromComment;
        org.springframework.core.io.Resource sourceResource;
        ExamplesTableRow cells;
        ExamplesTableRow examplesTableRow = cells = examples.getRows().isEmpty() ? null : (ExamplesTableRow)examples.getRows().get(0);
        if (cells != null && this.lineOffset != 0 && this.isPreview && cells.getComments().isEmpty()) {
            int newLine = cells.getLine() + this.lineOffset;
            this.featureLineOffset.put(cells.getLine(), newLine);
            List rows = examples.getRows();
            ArrayList<ExamplesTableRow> newRows = new ArrayList<ExamplesTableRow>();
            for (ExamplesTableRow examplesTableRow2 : rows) {
                this.featureLineOffset.put(examplesTableRow2.getLine(), examplesTableRow2.getLine() + this.lineOffset);
                ExamplesTableRow tableRow = new ExamplesTableRow(examplesTableRow2.getComments(), examplesTableRow2.getCells(), Integer.valueOf(examplesTableRow2.getLine() + this.lineOffset), examplesTableRow2.getId());
                newRows.add(tableRow);
            }
            examples.setRows(newRows);
        }
        if (cells != null && !cells.getComments().isEmpty() && (sourceResource = this.getSourceResource(filePathFromComment = this.getExtractFilePathFromComment(((Comment)cells.getComments().get(0)).getValue()))) != null) {
            this.loadAndReplaceExamples(examples, cells, filePathFromComment, sourceResource);
        }
        super.examples(examples);
        this.prettyFormatter.examples(examples);
    }

    private void loadAndReplaceExamples(Examples examples, ExamplesTableRow cells, String filePathFromComment, org.springframework.core.io.Resource sourceResource) {
        ArrayList<ExamplesTableRow> rows = new ArrayList<ExamplesTableRow>();
        List oldrows = examples.getRows();
        ExamplesTableRow tableRowHeader = (ExamplesTableRow)oldrows.get(0);
        rows.add(tableRowHeader);
        try {
            InputStream inputStream = sourceResource.getInputStream();
            DataReader dataReader = DataReaderFactory.create(sourceResource.getFilename());
            DataDTO data = dataReader.readExamples(inputStream);
            int lineNumOffset = 1;
            for (Integer lineNumInResource : data.getValues().keySet()) {
                List<String> values = data.getValues().get(lineNumInResource);
                String valueComment = String.format("# %s:%d", filePathFromComment, lineNumInResource + 1);
                Comment comment = new Comment(valueComment, lineNumInResource);
                ArrayList comments = Lists.newArrayList((Object[])new Comment[]{comment});
                int newLineNum = tableRowHeader.getLine() + lineNumOffset;
                if (this.isPreview) {
                    newLineNum += this.lineOffset.intValue();
                }
                ExamplesTableRow tableRow = new ExamplesTableRow((List)comments, values, Integer.valueOf(newLineNum), cells.getId());
                rows.add(tableRow);
                this.featureLineOffset.put(tableRowHeader.getLine() + lineNumOffset, newLineNum + 1);
                this.lineOffset = this.lineOffset + 1;
                ++lineNumOffset;
            }
            this.lineOffset = this.lineOffset + lineNumOffset - examples.getRows().size();
            examples.setRows(rows);
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void step(Step step) {
        String filePathFromComment;
        org.springframework.core.io.Resource sourceResource;
        if (this.lineOffset != 0 && this.isPreview) {
            int newLine = step.getLine() + this.lineOffset;
            this.featureLineOffset.put((int)step.getLine(), newLine);
            step = new Step(step.getComments(), step.getKeyword(), step.getName(), Integer.valueOf(newLine), step.getRows(), step.getDocString());
        }
        if (step.getRows() != null && step.getRows().get(0) != null && !((DataTableRow)step.getRows().get(0)).getComments().isEmpty() && (sourceResource = this.getSourceResource(filePathFromComment = this.getExtractFilePathFromComment(((Comment)((DataTableRow)step.getRows().get(0)).getComments().get(0)).getValue()))) != null) {
            step = this.loadAndReplaceSteps(step, filePathFromComment, sourceResource);
        }
        super.step(step);
        this.prettyFormatter.step(step);
    }

    private Step loadAndReplaceSteps(Step step, String filePathFromComment, org.springframework.core.io.Resource sourceResource) {
        try {
            InputStream inputStream = sourceResource.getInputStream();
            DataReader dataReader = DataReaderFactory.create(sourceResource.getFilename());
            DataDTO data = dataReader.readTable(inputStream);
            ArrayList rows = Lists.newArrayList();
            for (Integer lineNum : data.getValues().keySet()) {
                ArrayList cells = Lists.newArrayList((Iterable)data.getValues().get(lineNum));
                String valueComment = String.format("# %s:%d", filePathFromComment, lineNum + 1);
                Comment comment = new Comment(valueComment, lineNum);
                ArrayList comments = Lists.newArrayList((Object[])new Comment[]{comment});
                int newLineNum = step.getLine() + 2;
                if (this.isPreview) {
                    newLineNum += this.lineOffset.intValue();
                }
                DataTableRow row = new DataTableRow((List)comments, (List)cells, Integer.valueOf(newLineNum + 1));
                rows.add(row);
                this.lineOffset = this.lineOffset + 2;
            }
            this.lineOffset = this.lineOffset - step.getRows().size() - 1;
            step = new Step(step.getComments(), step.getKeyword(), step.getName(), step.getLine(), (List)rows, step.getDocString());
        }
        catch (IOException | IllegalAccessException | InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return step;
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        super.syntaxError(state, event, legalEvents, uri, line);
        this.prettyFormatter.syntaxError(state, event, legalEvents, uri, line);
    }

    public void done() {
        super.done();
        this.prettyFormatter.done();
    }

    public void close() {
        super.close();
        this.prettyFormatter.close();
    }

    public void eof() {
        super.eof();
        this.prettyFormatter.eof();
    }

    public PrettyFormatter getPrettyFormatter() {
        return this.prettyFormatter;
    }

    public void setPrettyFormatter(PrettyFormatter prettyFormatter) {
        this.prettyFormatter = prettyFormatter;
    }

    private String getExtractFilePathFromComment(String comment) {
        Matcher matcher = SOURCE_COMMENT_REGEX.matcher(comment);
        return matcher.matches() ? matcher.group(1).trim() : null;
    }

    private org.springframework.core.io.Resource getSourceResource(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute() && this.resourceDir != null) {
            return new FileSystemResource(new File(this.resourceDir, path));
        }
        if (!file.isAbsolute()) {
            String classLoaderPath = new File("").getAbsolutePath();
            File basePath = new File(this.baseDir, path);
            File resourcePath = new File(classLoaderPath, basePath.getPath());
            FileSystemResource classPathResource = new FileSystemResource(resourcePath.getPath());
            return classPathResource;
        }
        return new FileSystemResource(file);
    }

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths, List<Object> filters, PrintStream out) {
        List<CucumberFeature> cucumberFeatures = MiniumFeatureBuilder.load(resourceLoader, featurePaths, filters, null, null);
        if (cucumberFeatures.isEmpty()) {
            if (featurePaths.isEmpty()) {
                out.println(String.format("Got no path to feature directory or feature file", new Object[0]));
            } else if (filters.isEmpty()) {
                out.println(String.format("No features found at %s", featurePaths));
            } else {
                out.println(String.format("None of the features at %s matched the filters: %s", featurePaths, filters));
            }
        }
        return cucumberFeatures;
    }

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths, List<Object> filters, PrintStream out, File resourceDir) {
        List<CucumberFeature> cucumberFeatures = MiniumFeatureBuilder.load(resourceLoader, featurePaths, filters, resourceDir);
        if (cucumberFeatures.isEmpty()) {
            if (featurePaths.isEmpty()) {
                out.println(String.format("Got no path to feature directory or feature file", new Object[0]));
            } else if (filters.isEmpty()) {
                out.println(String.format("No features found at %s", featurePaths));
            } else {
                out.println(String.format("None of the features at %s matched the filters: %s", featurePaths, filters));
            }
        }
        return cucumberFeatures;
    }

    public static List<CucumberFeature> load(ResourceLoader resourceLoader, List<String> featurePaths, List<Object> filters, File resourceDir) {
        ArrayList<CucumberFeature> cucumberFeatures = new ArrayList<CucumberFeature>();
        MiniumFeatureBuilder builder = new MiniumFeatureBuilder(cucumberFeatures, resourceDir);
        for (String featurePath : featurePaths) {
            if (featurePath.startsWith("@")) {
                MiniumFeatureBuilder.loadFromRerunFile(builder, resourceLoader, featurePath.substring(1), filters);
                continue;
            }
            MiniumFeatureBuilder.loadFromFeaturePath(builder, resourceLoader, featurePath, filters, false);
        }
        Collections.sort(cucumberFeatures, new CucumberFeatureUriComparator());
        return cucumberFeatures;
    }

    private static void loadFromFeaturePath(MiniumFeatureBuilder builder, ResourceLoader resourceLoader, String featurePath, List<Object> filters, boolean failOnNoResource) {
        PathWithLines pathWithLines = new PathWithLines(featurePath);
        ArrayList<Object> filtersForPath = new ArrayList<Object>(filters);
        filtersForPath.addAll(pathWithLines.lines);
        Iterable resources = resourceLoader.resources(pathWithLines.path, ".feature");
        for (Resource resource : resources) {
            builder.parse(resource, filtersForPath);
        }
    }

    private static void loadFromRerunFile(MiniumFeatureBuilder builder, ResourceLoader resourceLoader, String rerunPath, List<Object> filters) {
        Iterable resources = resourceLoader.resources(rerunPath, null);
        for (Resource resource : resources) {
            String source = builder.read(resource);
            if (source.isEmpty()) continue;
            for (String featurePath : source.split(" ")) {
                MiniumFeatureBuilder.loadFromFileSystemOrClasspath(builder, resourceLoader, featurePath, filters);
            }
        }
    }

    private static void loadFromFileSystemOrClasspath(MiniumFeatureBuilder builder, ResourceLoader resourceLoader, String featurePath, List<Object> filters) {
        try {
            MiniumFeatureBuilder.loadFromFeaturePath(builder, resourceLoader, featurePath, filters, false);
        }
        catch (IllegalArgumentException originalException) {
            if (!featurePath.startsWith("classpath:") && originalException.getMessage().contains("Not a file or directory")) {
                try {
                    MiniumFeatureBuilder.loadFromFeaturePath(builder, resourceLoader, "classpath: " + featurePath, filters, true);
                }
                catch (IllegalArgumentException secondException) {
                    if (secondException.getMessage().contains("No resource found for")) {
                        throw new IllegalArgumentException("Neither found on file system or on classpath: " + originalException.getMessage() + ", " + secondException.getMessage());
                    }
                    throw secondException;
                }
            }
            throw originalException;
        }
    }

    public Map<Integer, Integer> getLineOffset() {
        return this.featureLineOffset;
    }

    public void setLineOffset(Map<Integer, Integer> lineOffset) {
        this.featureLineOffset = lineOffset;
    }

    private static class CucumberFeatureUriComparator
    implements Comparator<CucumberFeature> {
        private CucumberFeatureUriComparator() {
        }

        @Override
        public int compare(CucumberFeature a, CucumberFeature b) {
            return a.getPath().compareTo(b.getPath());
        }
    }
}

