/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.file.Blob;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.time.FastDateFormat;

@JsxClass
public class File
extends Blob {
    private static final String LAST_MODIFIED_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)";
    private static final String LAST_MODIFIED_DATE_FORMAT_FF = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    private java.io.File file_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f), @WebBrowser(value=BrowserName.EDGE)})
    public File() {
    }

    File(String pathname) {
        this.file_ = new java.io.File(pathname);
    }

    @JsxGetter
    public String getName() {
        return this.file_.getName();
    }

    @JsxGetter
    public String getLastModifiedDate() {
        Date date = new Date(this.getLastModified());
        BrowserVersion browser = this.getBrowserVersion();
        Locale locale = new Locale(browser.getSystemLanguage());
        if (browser.hasFeature(BrowserVersionFeatures.JS_FILE_SHORT_DATE_FORMAT)) {
            FastDateFormat format = FastDateFormat.getInstance((String)LAST_MODIFIED_DATE_FORMAT_FF, (Locale)locale);
            return format.format(date);
        }
        FastDateFormat format = FastDateFormat.getInstance((String)LAST_MODIFIED_DATE_FORMAT, (Locale)locale);
        return format.format(date);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f)})
    public long getLastModified() {
        return this.file_.lastModified();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public String getWebkitRelativePath() {
        return "";
    }

    @JsxGetter
    public long getSize() {
        return this.file_.length();
    }

    @JsxGetter
    public String getType() {
        try {
            return Files.probeContentType(this.file_.toPath());
        }
        catch (IOException e) {
            return "";
        }
    }

    @JsxFunction
    public void slice() {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE)})
    public void msClose() {
    }

    public java.io.File getFile() {
        return this.file_;
    }
}

