/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import minium.web.internal.expression.BaseExpression;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.RootExpression;
import minium.web.internal.expression.VariableGenerator;

public class FunctionInvocationExpression
extends BaseExpression {
    private final Expression parentExpression;
    private final String function;
    private final List<Expression> argExpressions;

    public FunctionInvocationExpression(Expression parentExpression, String function, Expression ... argExpressions) {
        this(parentExpression, function, Lists.newArrayList((Object[])argExpressions));
    }

    public FunctionInvocationExpression(Expression parentExpression, String function, List<Expression> argExpressions) {
        this.parentExpression = parentExpression;
        this.function = function;
        this.argExpressions = argExpressions;
    }

    @Override
    public String getJavascript(VariableGenerator varGenerator) {
        if ("find".equals(this.function) && this.parentExpression instanceof RootExpression && this.parentExpression.getArgs() == null) {
            return String.format("$(%s)", this.argsAsString(varGenerator));
        }
        return String.format("%s.%s(%s)", this.parentExpression.getJavascript(varGenerator), this.function, this.argsAsString(varGenerator));
    }

    @Override
    public Object[] getArgs() {
        ArrayList allArgs = Lists.newArrayList();
        this.addArgs(allArgs, this.parentExpression.getArgs());
        for (Expression argExpression : this.argExpressions) {
            this.addArgs(allArgs, argExpression.getArgs());
        }
        return Iterables.toArray((Iterable)allArgs, Object.class);
    }

    protected void addArgs(List<Object> args, Object[] expressionArgs) {
        if (expressionArgs != null) {
            args.addAll(Arrays.asList(expressionArgs));
        }
    }

    protected String argsAsString(VariableGenerator varGenerator) {
        ArrayList argJavascripts = Lists.newArrayList();
        for (Expression argExpression : this.argExpressions) {
            argJavascripts.add(argExpression.getJavascript(varGenerator));
        }
        return Joiner.on((String)", ").join((Iterable)argJavascripts);
    }
}

