/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.compressor;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.io.Closeables;
import com.google.common.io.Resources;
import com.google.javascript.jscomp.SourceFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import minium.web.internal.ResourceException;

public class ResourceFunctions {
    public static Function<String, SourceFile> classpathFileToSourceFileFunction(ClassLoader classLoader) {
        return new ClasspathFileToSourceFileFunction(classLoader);
    }

    public static Function<String, String> classpathFileToStringFunction(ClassLoader classLoader) {
        return new ClasspathFileToStringFunction(classLoader);
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            Closeables.close((Closeable)closeable, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ClasspathFileToStringFunction
    implements Function<String, String> {
        private final ClassLoader classLoader;

        public ClasspathFileToStringFunction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public String apply(String filePath) {
            try {
                URL resource = this.classLoader.getResource(filePath);
                return Resources.toString((URL)resource, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new ResourceException(e);
            }
        }
    }

    private static class ClasspathFileToSourceFileFunction
    implements Function<String, SourceFile> {
        private final ClassLoader classLoader;

        public ClasspathFileToSourceFileFunction(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public SourceFile apply(String filePath) {
            SourceFile sourceFile;
            Reader reader = null;
            try {
                URL resource = this.classLoader.getResource(filePath);
                reader = Resources.asCharSource((URL)resource, (Charset)Charsets.UTF_8).openStream();
                sourceFile = SourceFile.fromReader((String)filePath, (Reader)reader);
            }
            catch (IOException e) {
                try {
                    throw new ResourceException(e);
                }
                catch (Throwable throwable) {
                    ResourceFunctions.closeQuietly(reader);
                    throw throwable;
                }
            }
            ResourceFunctions.closeQuietly(reader);
            return sourceFile;
        }
    }
}

