/*
 * Decompiled with CFR 0.152.
 */
package minium.actions.internal;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Callables;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import minium.Elements;
import minium.ElementsException;
import minium.actions.Configuration;
import minium.actions.Duration;
import minium.actions.HasConfiguration;
import minium.actions.TimeoutException;

public class Waits {
    private static Wait wait = new Wait();

    public static void setInstance(Wait wait) {
        Waits.wait = wait;
    }

    public static void waitForPredicate(Elements elements, String preset, Predicate<? super Elements> predicate) {
        wait.forPredicate(elements, preset, predicate);
    }

    public static void waitForPredicate(Elements elements, Duration timeout, Duration interval, Predicate<? super Elements> predicate) {
        wait.forPredicate(elements, timeout, interval, predicate);
    }

    public static boolean waitForPredicateOrTimeout(Elements elements, String preset, Predicate<? super Elements> predicate) {
        return wait.forPredicateOrTimeout(elements, preset, predicate);
    }

    public static boolean waitForPredicateOrTimeout(Elements elements, Duration timeout, Duration interval, Predicate<? super Elements> predicate) {
        return wait.forPredicateOrTimeout(elements, timeout, interval, predicate);
    }

    public static void waitTime(Duration duration) {
        wait.time(duration);
    }

    public static class Wait {
        public void forPredicate(Elements elements, String preset, Predicate<? super Elements> predicate) {
            Configuration configuration = ((HasConfiguration)elements.as(HasConfiguration.class)).configure();
            Configuration.WaitingPreset waitingPreset = configuration.waitingPreset(preset);
            this.forPredicate(elements, waitingPreset.timeout(), waitingPreset.interval(), predicate);
        }

        public void forPredicate(Elements elements, Duration timeout, Duration interval, Predicate<? super Elements> predicate) {
            Configuration configuration = ((HasConfiguration)elements.as(HasConfiguration.class)).configure();
            if (timeout == null) {
                timeout = configuration.defaultTimeout();
            }
            if (interval == null) {
                interval = configuration.defaultInterval();
            }
            Retryer<? super Elements> retrier = this.getRetryer(predicate, timeout, interval);
            try {
                retrier.call(Callables.returning((Object)elements));
            }
            catch (RetryException e) {
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
                throw new TimeoutException(predicate, elements, e.getNumberOfFailedAttempts());
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }

        public boolean forPredicateOrTimeout(Elements elements, String preset, Predicate<? super Elements> predicate) {
            Configuration configuration = ((HasConfiguration)elements.as(HasConfiguration.class)).configure();
            Configuration.WaitingPreset waitingPreset = configuration.waitingPreset(preset);
            return this.forPredicateOrTimeout(elements, waitingPreset.timeout(), waitingPreset.interval(), predicate);
        }

        public boolean forPredicateOrTimeout(Elements elements, Duration timeout, Duration interval, Predicate<? super Elements> predicate) {
            Configuration configuration = ((HasConfiguration)elements.as(HasConfiguration.class)).configure();
            if (timeout == null) {
                timeout = configuration.defaultTimeout();
            }
            if (interval == null) {
                interval = configuration.defaultInterval();
            }
            Retryer<? super Elements> retrier = this.getRetryer(predicate, timeout, interval);
            try {
                retrier.call(Callables.returning((Object)elements));
                return true;
            }
            catch (RetryException e) {
                if (Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    throw Throwables.propagate((Throwable)e);
                }
                return false;
            }
            catch (ExecutionException e) {
                throw Throwables.propagate((Throwable)e.getCause());
            }
        }

        public void time(Duration waitTime) {
            long time = waitTime.getTime();
            TimeUnit unit = waitTime.getUnit();
            try {
                Thread.sleep(unit.toMillis(time));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ElementsException((Throwable)e);
            }
        }

        protected <T> Retryer<T> getRetryer(Predicate<? super T> predicate, Duration timeout, Duration interval) {
            return RetryerBuilder.newBuilder().retryIfResult(Predicates.not(predicate)).retryIfRuntimeException().withWaitStrategy(WaitStrategies.fixedWait((long)interval.getTime(), (TimeUnit)interval.getUnit())).withStopStrategy(StopStrategies.stopAfterDelay((long)timeout.getTime(), (TimeUnit)timeout.getUnit())).build();
        }
    }
}

