/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.report.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.hash.Hashing;
import minium.cucumber.report.domain.JsonBase64Deserializer;
import minium.cucumber.report.domain.Views;

public class Embedding {
    @JsonView(value={Views.Public.class})
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonView(value={Views.Full.class})
    @JsonDeserialize(using=JsonBase64Deserializer.class)
    private byte[] data;
    @JsonView(value={Views.Public.class})
    @JsonProperty(value="sha1_hash")
    private String sha1Hash;

    public String getMimeType() {
        return this.mimeType;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSha1Hash() {
        if (this.sha1Hash == null && this.data != null) {
            this.sha1Hash = Hashing.sha1().hashBytes(this.data).toString();
        }
        return this.sha1Hash;
    }
}

