/*
 * Decompiled with CFR 0.152.
 */
package minium.script.rhinojs;

import java.lang.reflect.Type;
import minium.script.rhinojs.JsFunctionWebElements;
import minium.web.internal.WebElementsFactory;
import minium.web.internal.WebModule;
import minium.web.internal.expression.BasicExpression;
import minium.web.internal.expression.Coercer;
import minium.web.internal.expression.Expression;
import minium.web.internal.expression.Expressionizer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.json.JsonParser;

public class RhinoWebModules {
    public static WebModule rhinoModule() {
        return new WebModule(){

            public void configure(WebElementsFactory.Builder<?> builder) {
                builder.withJsResources(new String[]{"minium/web/internal/lib/jquery.min.js", "minium/script/js/internal/lib/jquery.functionCall.js"}).implementingInterfaces(new Class[]{JsFunctionWebElements.class}).withExpressionizers(new Expressionizer[]{new FunctionExpressionizer()}).withCoercers(new Coercer[]{new RhinoObjectCoercer()});
            }

            public String toString() {
                return "WebModule[rhino]";
            }
        };
    }

    public static class RhinoObjectCoercer
    implements Coercer {
        public boolean handles(Object obj, Type type) {
            if (type == Object.class) {
                return true;
            }
            return type instanceof Class && Scriptable.class.isAssignableFrom((Class)type);
        }

        public Object coerce(Object obj, Type type) {
            Context cx = Context.enter();
            try {
                if (obj instanceof String) {
                    return new JsonParser(cx, (Scriptable)cx.initStandardObjects()).parseValue((String)obj);
                }
                return obj;
            }
            catch (JsonParser.ParseException e) {
                return obj;
            }
        }
    }

    public static class FunctionExpressionizer
    implements Expressionizer {
        public boolean handles(Object obj) {
            return obj instanceof Function;
        }

        public Expression apply(Object obj) {
            Function fn = (Function)obj;
            Function toString = (Function)fn.getPrototype().get("toString", (Scriptable)fn);
            Context cx = Context.enter();
            return new BasicExpression((String)toString.call(cx, (Scriptable)fn, (Scriptable)fn, new Object[0]));
        }
    }
}

