/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.client;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.security.oauth2.client.EnableOAuth2Sso;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

class EnableOAuth2SsoCondition
extends SpringBootCondition {
    EnableOAuth2SsoCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String[] enablers = context.getBeanFactory().getBeanNamesForAnnotation(EnableOAuth2Sso.class);
        ConditionMessage.Builder message = ConditionMessage.forCondition("@EnableOAuth2Sso Condition", new Object[0]);
        for (String name : enablers) {
            if (!context.getBeanFactory().isTypeMatch(name, WebSecurityConfigurerAdapter.class)) continue;
            return ConditionOutcome.match(message.found("@EnableOAuth2Sso annotation on WebSecurityConfigurerAdapter").items(name));
        }
        return ConditionOutcome.noMatch(message.didNotFind("@EnableOAuth2Sso annotation on any WebSecurityConfigurerAdapter").atAll());
    }
}

