/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.compress.resources;

import org.apache.ant.compress.resources.ArResource;
import org.apache.ant.compress.resources.CommonsCompressArchiveScanner;
import org.apache.ant.compress.util.ArStreamFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.ArchiveFileSet;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;

public class ArFileSet
extends ArchiveFileSet {
    private boolean userIdSet;
    private boolean groupIdSet;
    private int uid;
    private int gid;
    private boolean skipUnreadable = false;

    public ArFileSet() {
    }

    protected ArFileSet(FileSet fileset) {
        super(fileset);
    }

    protected ArFileSet(ArFileSet fileset) {
        super((ArchiveFileSet)fileset);
    }

    public void setUid(int uid) {
        this.checkArFileSetAttributesAllowed();
        this.userIdSet = true;
        this.uid = uid;
    }

    public int getUid() {
        if (this.isReference()) {
            return ((ArFileSet)((Object)this.getCheckedRef())).getUid();
        }
        return this.uid;
    }

    public boolean hasUserIdBeenSet() {
        return this.userIdSet;
    }

    public void setGid(int gid) {
        this.checkArFileSetAttributesAllowed();
        this.groupIdSet = true;
        this.gid = gid;
    }

    public int getGid() {
        if (this.isReference()) {
            return ((ArFileSet)((Object)this.getCheckedRef())).getGid();
        }
        return this.gid;
    }

    public boolean hasGroupIdBeenSet() {
        return this.groupIdSet;
    }

    public void setSkipUnreadableEntries(boolean b) {
        this.skipUnreadable = b;
    }

    protected ArchiveScanner newArchiveScanner() {
        return new CommonsCompressArchiveScanner(new ArStreamFactory(), new CommonsCompressArchiveScanner.ResourceBuilder(){

            public Resource buildResource(Resource archive, String encoding, ArchiveEntry entry) {
                return new ArResource(archive, (ArArchiveEntry)entry);
            }
        }, this.skipUnreadable, this.getProject());
    }

    public void setRefid(Reference r) throws BuildException {
        if (this.userIdSet || this.groupIdSet) {
            throw this.tooManyAttributes();
        }
        super.setRefid(r);
    }

    protected AbstractFileSet getRef(Project p) {
        this.dieOnCircularReference(p);
        Object o = this.getRefid().getReferencedObject(p);
        if (o instanceof ArFileSet) {
            return (AbstractFileSet)o;
        }
        if (o instanceof FileSet) {
            ArFileSet zfs = new ArFileSet((FileSet)o);
            this.configureFileSet(zfs);
            return zfs;
        }
        String msg = this.getRefid().getRefId() + " doesn't denote a arfileset or a fileset";
        throw new BuildException(msg);
    }

    protected void configureFileSet(ArchiveFileSet zfs) {
        super.configureFileSet(zfs);
        if (zfs instanceof ArFileSet) {
            ArFileSet tfs = (ArFileSet)zfs;
            tfs.setUid(this.uid);
            tfs.setGid(this.gid);
        }
    }

    public Object clone() {
        if (this.isReference()) {
            return ((ArFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private void checkArFileSetAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof ArFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

