/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.messaging.simp.user.SimpSession;
import org.springframework.messaging.simp.user.SimpSubscription;
import org.springframework.messaging.simp.user.SimpSubscriptionMatcher;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.CollectionUtils;

public class UserSessionRegistryAdapter
implements SimpUserRegistry {
    private final UserSessionRegistry userSessionRegistry;

    public UserSessionRegistryAdapter(UserSessionRegistry registry) {
        this.userSessionRegistry = registry;
    }

    @Override
    public SimpUser getUser(String userName) {
        Set<String> sessionIds = this.userSessionRegistry.getSessionIds(userName);
        return !CollectionUtils.isEmpty(sessionIds) ? new SimpUserAdapter(userName, sessionIds) : null;
    }

    @Override
    public Set<SimpUser> getUsers() {
        throw new UnsupportedOperationException("UserSessionRegistry does not expose a listing of users");
    }

    @Override
    public Set<SimpSubscription> findSubscriptions(SimpSubscriptionMatcher matcher) {
        throw new UnsupportedOperationException("UserSessionRegistry does not support operations across users");
    }

    private static class SimpSessionAdapter
    implements SimpSession {
        private final String id;

        public SimpSessionAdapter(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public SimpUser getUser() {
            return null;
        }

        @Override
        public Set<SimpSubscription> getSubscriptions() {
            return Collections.emptySet();
        }
    }

    private static class SimpUserAdapter
    implements SimpUser {
        private final String name;
        private final Map<String, SimpSession> sessions;

        public SimpUserAdapter(String name, Set<String> sessionIds) {
            this.name = name;
            this.sessions = new HashMap<String, SimpSession>(sessionIds.size());
            for (String sessionId : sessionIds) {
                this.sessions.put(sessionId, new SimpSessionAdapter(sessionId));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasSessions() {
            return !this.sessions.isEmpty();
        }

        @Override
        public SimpSession getSession(String sessionId) {
            return this.sessions.get(sessionId);
        }

        @Override
        public Set<SimpSession> getSessions() {
            return new HashSet<SimpSession>(this.sessions.values());
        }
    }
}

