/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.ErrorState;
import org.apache.coyote.PushToken;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class StreamProcessor
extends AbstractProcessor
implements Runnable {
    private static final Log log = LogFactory.getLog(StreamProcessor.class);
    private static final StringManager sm = StringManager.getManager(StreamProcessor.class);
    private final Http2UpgradeHandler handler;
    private final Stream stream;

    public StreamProcessor(Http2UpgradeHandler handler, Stream stream, Adapter adapter, SocketWrapperBase<?> socketWrapper) {
        super(stream.getCoyoteRequest(), stream.getCoyoteResponse());
        this.handler = handler;
        this.stream = stream;
        this.setAdapter(adapter);
        this.setSocketWrapper(socketWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            StreamProcessor streamProcessor = this;
            synchronized (streamProcessor) {
                ContainerThreadMarker.set();
                AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
                try {
                    state = this.process(this.socketWrapper, SocketEvent.OPEN_READ);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        if (!this.getErrorState().isConnectionIoAllowed()) {
                            ConnectionException ce = new ConnectionException(sm.getString("streamProcessor.error.connection", this.stream.getConnectionId(), this.stream.getIdentifier()), Http2Error.INTERNAL_ERROR);
                            this.stream.close(ce);
                        } else if (!this.getErrorState().isIoAllowed()) {
                            StreamException se = new StreamException(sm.getString("streamProcessor.error.stream", this.stream.getConnectionId(), this.stream.getIdentifier()), Http2Error.INTERNAL_ERROR, this.stream.getIdentifier());
                            this.stream.close(se);
                        }
                    }
                }
                catch (Exception e) {
                    ConnectionException ce = new ConnectionException(sm.getString("streamProcessor.error.connection", this.stream.getConnectionId(), this.stream.getIdentifier()), Http2Error.INTERNAL_ERROR);
                    ce.initCause(e);
                    this.stream.close(ce);
                }
                finally {
                    ContainerThreadMarker.clear();
                }
            }
        }
        finally {
            this.handler.executeQueuedStream();
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        this.response.setCommitted(true);
        this.stream.writeHeaders();
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.stream.getOutputBuffer().close();
    }

    @Override
    protected final void ack() {
        if (!this.response.isCommitted() && this.request.hasExpectation()) {
            try {
                this.stream.writeAck();
            }
            catch (IOException ioe) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
            }
        }
    }

    @Override
    protected final void flush() throws IOException {
        this.stream.flushData();
    }

    @Override
    protected final int available(boolean doRead) {
        return this.stream.getInputBuffer().available();
    }

    @Override
    protected final void setRequestBody(ByteChunk body) {
        this.stream.getInputBuffer().insertReplayedBody(body);
        this.stream.receivedEndOfStream();
    }

    @Override
    protected final void setSwallowResponse() {
    }

    @Override
    protected final void disableSwallowRequest() {
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.stream.getInputBuffer().isRequestBodyFullyRead();
    }

    @Override
    protected final void registerReadInterest() {
        this.stream.getInputBuffer().registerReadInterest();
    }

    @Override
    protected final boolean isReady() {
        return this.stream.getOutputBuffer().isReady();
    }

    @Override
    protected final void executeDispatches(SocketWrapperBase<?> wrapper) {
        wrapper.getEndpoint().getExecutor().execute(this);
    }

    @Override
    protected final boolean isPushSupported() {
        return this.stream.isPushSupported();
    }

    @Override
    protected final void doPush(PushToken pushToken) {
        try {
            pushToken.setResult(this.stream.push(pushToken.getPushTarget()));
        }
        catch (IOException ioe) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, ioe);
            this.response.setErrorException(ioe);
        }
    }

    @Override
    public void recycle() {
        this.setSocketWrapper(null);
        this.setAdapter(null);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public void pause() {
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socket) throws IOException {
        try {
            this.adapter.service(this.request, this.response);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("streamProcessor.service.error"), e);
            }
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        if (this.getErrorState().isError()) {
            this.action(ActionCode.CLOSE, null);
            this.request.updateCounters();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.action(ActionCode.CLOSE, null);
        this.request.updateCounters();
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (this.stream.getOutputBuffer().flush(false)) {
            if (this.stream.getOutputBuffer().isReady()) {
                throw new IllegalStateException();
            }
            return true;
        }
        return false;
    }

    @Override
    protected AbstractEndpoint.Handler.SocketState dispatchEndRequest() {
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }
}

