/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface Coercer {
    public boolean handles(Object var1, Type var2);

    public Object coerce(Object var1, Type var2);

    public static class Composite
    implements Coercer {
        private final List<Coercer> coercers = Lists.newArrayList();

        public Composite add(Coercer processor) {
            this.coercers.add(processor);
            return this;
        }

        public Composite addAll(Collection<? extends Coercer> processor) {
            this.coercers.addAll(processor);
            return this;
        }

        public Composite addAll(Coercer ... processor) {
            return this.addAll(Arrays.asList(processor));
        }

        @Override
        public boolean handles(Object obj, Type type) {
            Coercer coercer = this.coercerFor(obj, type);
            return coercer != null;
        }

        @Override
        public Object coerce(Object obj, Type type) {
            Coercer coercer = (Coercer)Preconditions.checkNotNull((Object)this.coercerFor(obj, type), (String)"No coercer found for %s with type %s", (Object[])new Object[]{obj, type});
            return coercer.coerce(obj, type);
        }

        protected Coercer coercerFor(Object obj, Type type) {
            for (Coercer coercer : Lists.reverse(this.coercers)) {
                if (!coercer.handles(obj, type)) continue;
                return coercer;
            }
            return null;
        }
    }
}

