/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.compressor;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import minium.web.internal.compressor.Compressor;
import minium.web.internal.compressor.ResourceFunctions;

public class ClosureCompressor
implements Compressor {
    @Override
    public String compress(ClassLoader classLoader, Collection<String> jsResources) throws IOException {
        Compiler compiler = new Compiler();
        compiler.disableThreads();
        Collection sourceFiles = Collections2.transform(jsResources, ResourceFunctions.classpathFileToSourceFileFunction(classLoader));
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        compiler.compile(CommandLineRunner.getDefaultExterns(), (List)Lists.newArrayList((Iterable)sourceFiles), options);
        return compiler.toSource();
    }
}

