/*
 * Decompiled with CFR 0.152.
 */
package minium.web.internal.actions;

import com.google.common.collect.Iterables;
import minium.Elements;
import minium.actions.InteractionListener;
import minium.actions.TimeoutException;
import minium.actions.internal.AfterFailInteractionEvent;
import minium.actions.internal.DefaultInteractionListener;
import minium.actions.internal.WaitForExistenceInteraction;
import minium.actions.internal.WaitingPresetInteractionListener;
import minium.web.internal.InternalWebElements;

public class RetryAfterWaitingWhileEmptyInteractionListener
extends DefaultInteractionListener {
    private final Elements waitElements;
    private final String waitingPreset;

    public RetryAfterWaitingWhileEmptyInteractionListener(Elements source, String waitingPreset) {
        this.waitElements = source;
        this.waitingPreset = waitingPreset;
    }

    protected void onAfterFailEvent(AfterFailInteractionEvent event) {
        if (!(event.getException() instanceof TimeoutException)) {
            return;
        }
        if (Iterables.isEmpty(((InternalWebElements)this.waitElements.as(InternalWebElements.class)).wrappedNativeElements())) {
            try {
                WaitForExistenceInteraction interaction = new WaitForExistenceInteraction(this.waitElements, null);
                interaction.registerListener((InteractionListener)new WaitingPresetInteractionListener(this.waitingPreset));
                interaction.perform();
                event.setRetry(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

