/*
 * Decompiled with CFR 0.152.
 */
package minium.actions.internal;

import java.util.concurrent.TimeUnit;
import minium.ElementsException;
import minium.actions.Duration;
import minium.actions.Interactable;
import minium.actions.WaitInteractable;
import minium.actions.internal.AbstractInteractable;
import minium.actions.internal.CheckForExistenceInteraction;
import minium.actions.internal.CheckForUnexistenceInteraction;
import minium.actions.internal.WaitForExistenceInteraction;
import minium.actions.internal.WaitForUnexistenceInteraction;
import minium.actions.internal.WaitTimeInteraction;

public class DefaultWaitInteractable<T extends Interactable<?>>
extends AbstractInteractable<T>
implements WaitInteractable<T> {
    @Override
    public T waitForExistence() throws ElementsException {
        return this.waitForExistence(null);
    }

    @Override
    public T waitForExistence(String waitingPreset) {
        return this.perform(new WaitForExistenceInteraction(this.getSource(), waitingPreset));
    }

    @Override
    public T waitForUnexistence() throws ElementsException {
        return this.waitForUnexistence(null);
    }

    @Override
    public T waitForUnexistence(String waitingPreset) throws ElementsException {
        return this.perform(new WaitForUnexistenceInteraction(this.getSource(), waitingPreset));
    }

    @Override
    public boolean checkForExistence() {
        return this.checkForExistence(null);
    }

    @Override
    public boolean checkForExistence(String waitingPreset) {
        CheckForExistenceInteraction interaction = new CheckForExistenceInteraction(this.getSource(), waitingPreset);
        this.perform(interaction);
        return !interaction.isEmpty();
    }

    @Override
    public boolean checkForUnexistence() {
        return this.checkForUnexistence(null);
    }

    @Override
    public boolean checkForUnexistence(String waitingPreset) {
        CheckForUnexistenceInteraction interaction = new CheckForUnexistenceInteraction(this.getSource(), waitingPreset);
        this.perform(interaction);
        return interaction.isEmpty();
    }

    @Override
    public T waitTime(long time, TimeUnit unit) {
        return this.perform(new WaitTimeInteraction(new Duration(time, unit)));
    }
}

