/*
 * Decompiled with CFR 0.152.
 */
package minium.actions.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import minium.Elements;
import minium.FreezableElements;
import minium.IterableElements;
import minium.actions.Configuration;
import minium.actions.Duration;
import minium.actions.HasConfiguration;
import minium.actions.Interaction;
import minium.actions.InteractionEvent;
import minium.actions.InteractionListener;
import minium.actions.internal.AfterFailInteractionEvent;
import minium.actions.internal.AfterSuccessInteractionEvent;
import minium.actions.internal.BeforeInteractionEvent;
import minium.actions.internal.BeforeWaitInteractionEvent;
import minium.actions.internal.WaitPredicates;
import minium.actions.internal.Waits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInteraction
implements Interaction {
    private static final Logger logger = LoggerFactory.getLogger(AbstractInteraction.class);
    private final Set<InteractionListener> listeners = Sets.newLinkedHashSet();
    private final Elements originalSource;
    private final boolean canFreeze;
    private Elements source;
    private String preset;

    public AbstractInteraction(Elements elems) {
        this(elems, true);
    }

    public AbstractInteraction(Elements elems, boolean canFreeze) {
        this.originalSource = elems;
        this.canFreeze = canFreeze;
        this.refreeze();
    }

    public void refreeze() {
        if (this.originalSource != null) {
            this.source = this.originalSource.is(FreezableElements.class) && this.canFreeze ? ((FreezableElements)this.originalSource.as(FreezableElements.class)).freeze() : this.originalSource;
        }
    }

    public void setWaitingPreset(String preset) {
        this.preset = preset;
    }

    public String getWaitingPreset() {
        return this.preset;
    }

    @Override
    public void waitToPerform() {
        this.waitFor(WaitPredicates.forExistence());
    }

    @Override
    public void perform() {
        this.perform(true);
    }

    @Override
    public void registerListener(InteractionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(InteractionListener listener) {
        this.listeners.remove(listener);
    }

    protected void waitFor(Predicate<? super Elements> predicate) {
        if (this.source != null) {
            this.wait(this.source, this.preset, predicate);
        }
    }

    protected void waitOrTimeoutFor(Predicate<? super Elements> predicate) {
        if (this.source != null) {
            this.waitOrTimeout(this.source, this.preset, predicate);
        }
    }

    protected Elements getSource() {
        return this.source;
    }

    protected abstract void doPerform();

    protected Elements getFirst(Elements elems) {
        IterableElements iterableElems = (IterableElements)elems.as(IterableElements.class);
        return (Elements)Iterables.getFirst((Iterable)iterableElems, null);
    }

    protected boolean trigger(InteractionEvent.Type type, Throwable e) {
        return this.trigger(this.getAllListeners(), type, e);
    }

    protected boolean triggerReverse(InteractionEvent.Type type, Throwable e) {
        return this.trigger(Lists.reverse(this.getAllListeners()), type, e);
    }

    protected boolean trigger(List<InteractionListener> listeners, InteractionEvent.Type type, Throwable e) {
        if (listeners.isEmpty()) {
            return false;
        }
        InteractionEvent event = this.createInteractionEvent(type, e);
        for (InteractionListener listener : listeners) {
            listener.onEvent(event);
        }
        if (event instanceof AfterFailInteractionEvent) {
            return ((AfterFailInteractionEvent)event).isRetry();
        }
        return false;
    }

    private void perform(boolean canRetry) {
        this.trigger(InteractionEvent.Type.BEFORE_WAIT, null);
        try {
            this.waitToPerform();
            this.trigger(InteractionEvent.Type.BEFORE, null);
            this.doPerform();
            this.triggerReverse(InteractionEvent.Type.AFTER_SUCCESS, null);
        }
        catch (RuntimeException e) {
            boolean retry = this.triggerReverse(InteractionEvent.Type.AFTER_FAIL, e);
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                throw e;
            }
            if (retry && canRetry) {
                logger.debug("Interaction was marked as retriable, let's retry it");
                this.perform(false);
            }
            throw e;
        }
    }

    protected InteractionEvent createInteractionEvent(InteractionEvent.Type type, Throwable e) {
        Preconditions.checkNotNull((Object)((Object)type));
        switch (type) {
            case BEFORE_WAIT: {
                return new BeforeWaitInteractionEvent(this.source, this);
            }
            case BEFORE: {
                return new BeforeInteractionEvent(this.source, this);
            }
            case AFTER_FAIL: {
                return new AfterFailInteractionEvent(this.source, this, e);
            }
            case AFTER_SUCCESS: {
                return new AfterSuccessInteractionEvent(this.source, this);
            }
        }
        throw new IllegalArgumentException("Type must be not null and valid");
    }

    private List<InteractionListener> getAllListeners() {
        ArrayList allListeners = Lists.newArrayList();
        if (this.source != null && this.source.is(HasConfiguration.class)) {
            Configuration.InteractionListenerCollection globalListeners = ((HasConfiguration)this.source.as(HasConfiguration.class)).configure().interactionListeners();
            allListeners.addAll(Lists.newArrayList((Iterable)globalListeners));
        }
        allListeners.addAll(this.listeners);
        return allListeners;
    }

    protected void wait(Elements webElements, String preset, Predicate<? super Elements> predicate) {
        Configuration.WaitingPreset waitingPreset = this.configure().waitingPreset(preset);
        this.wait(webElements, waitingPreset.timeout(), waitingPreset.interval(), predicate);
    }

    protected void wait(Elements elems, Duration timeout, Duration interval, Predicate<? super Elements> predicate) {
        Waits.waitForPredicate(elems, timeout, interval, predicate);
    }

    protected void waitOrTimeout(Elements webElements, String preset, Predicate<? super Elements> predicate) {
        Configuration.WaitingPreset waitingPreset = this.configure().waitingPreset(preset);
        this.waitOrTimeout(webElements, waitingPreset.timeout(), waitingPreset.interval(), predicate);
    }

    protected void waitOrTimeout(Elements elems, Duration timeout, Duration interval, Predicate<? super Elements> predicate) {
        Waits.waitForPredicateOrTimeout(elems, timeout, interval, predicate);
    }

    private Configuration configure() {
        return ((HasConfiguration)this.getSource().as(HasConfiguration.class)).configure();
    }
}

