/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest.dto;

import com.google.common.collect.Lists;
import gherkin.formatter.model.Comment;
import java.util.ArrayList;
import java.util.List;

public class CommentDTO {
    private String value;
    private Integer line;

    public CommentDTO() {
    }

    public CommentDTO(Comment comment) {
        this.value = comment.getValue();
        this.line = comment.getLine();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public Comment toComment() {
        return new Comment(this.value, this.line);
    }

    public static List<Comment> toGherkinComments(List<CommentDTO> comments) {
        if (comments == null) {
            return null;
        }
        ArrayList gherkinComments = Lists.newArrayList();
        for (CommentDTO comment : comments) {
            gherkinComments.add(comment.toComment());
        }
        return gherkinComments;
    }

    public static List<CommentDTO> fromGherkinComments(List<Comment> gherkinComments) {
        if (gherkinComments == null) {
            return null;
        }
        ArrayList comments = Lists.newArrayList();
        for (Comment gherkinComment : gherkinComments) {
            comments.add(new CommentDTO(gherkinComment));
        }
        return comments;
    }
}

