/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

public class ResponseEntity<T>
extends HttpEntity<T> {
    private final Object statusCode;

    public ResponseEntity(HttpStatus status) {
        this(null, null, status);
    }

    public ResponseEntity(T body, HttpStatus status) {
        this(body, null, status);
    }

    public ResponseEntity(MultiValueMap<String, String> headers, HttpStatus status) {
        this(null, headers, status);
    }

    public ResponseEntity(T body, MultiValueMap<String, String> headers, HttpStatus status) {
        super(body, headers);
        Assert.notNull((Object)((Object)status), (String)"HttpStatus must not be null");
        this.statusCode = status;
    }

    private ResponseEntity(T body, MultiValueMap<String, String> headers, Object statusCode) {
        super(body, headers);
        this.statusCode = statusCode;
    }

    public HttpStatus getStatusCode() {
        if (this.statusCode instanceof HttpStatus) {
            return (HttpStatus)((Object)this.statusCode);
        }
        return HttpStatus.valueOf((Integer)this.statusCode);
    }

    public int getStatusCodeValue() {
        if (this.statusCode instanceof HttpStatus) {
            return ((HttpStatus)((Object)this.statusCode)).value();
        }
        return (Integer)this.statusCode;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        ResponseEntity otherEntity = (ResponseEntity)other;
        return ObjectUtils.nullSafeEquals((Object)this.statusCode, (Object)otherEntity.statusCode);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 29 + ObjectUtils.nullSafeHashCode((Object)this.statusCode);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.statusCode.toString());
        if (this.statusCode instanceof HttpStatus) {
            builder.append(' ');
            builder.append(((HttpStatus)((Object)this.statusCode)).getReasonPhrase());
        }
        builder.append(',');
        Object body = this.getBody();
        HttpHeaders headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            if (headers != null) {
                builder.append(',');
            }
        }
        if (headers != null) {
            builder.append(headers);
        }
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder status(HttpStatus status) {
        Assert.notNull((Object)((Object)status), (String)"HttpStatus must not be null");
        return new DefaultBuilder((Object)status);
    }

    public static BodyBuilder status(int status) {
        return new DefaultBuilder(status);
    }

    public static BodyBuilder ok() {
        return ResponseEntity.status(HttpStatus.OK);
    }

    public static <T> ResponseEntity<T> ok(T body) {
        BodyBuilder builder = ResponseEntity.ok();
        return builder.body(body);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = ResponseEntity.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return ResponseEntity.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return ResponseEntity.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder badRequest() {
        return ResponseEntity.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return ResponseEntity.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return ResponseEntity.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    private static class DefaultBuilder
    implements BodyBuilder {
        private final Object statusCode;
        private final HttpHeaders headers = new HttpHeaders();

        public DefaultBuilder(Object statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public BodyBuilder header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.headers.add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public BodyBuilder headers(HttpHeaders headers) {
            if (headers != null) {
                this.headers.putAll((Map<? extends String, ? extends List<String>>)((Object)headers));
            }
            return this;
        }

        @Override
        public BodyBuilder allow(HttpMethod ... allowedMethods) {
            this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
            return this;
        }

        @Override
        public BodyBuilder contentLength(long contentLength) {
            this.headers.setContentLength(contentLength);
            return this;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            this.headers.setContentType(contentType);
            return this;
        }

        @Override
        public BodyBuilder eTag(String eTag) {
            if (eTag != null) {
                if (!eTag.startsWith("\"") && !eTag.startsWith("W/\"")) {
                    eTag = "\"" + eTag;
                }
                if (!eTag.endsWith("\"")) {
                    eTag = eTag + "\"";
                }
            }
            this.headers.setETag(eTag);
            return this;
        }

        @Override
        public BodyBuilder lastModified(long date) {
            this.headers.setLastModified(date);
            return this;
        }

        @Override
        public BodyBuilder location(URI location) {
            this.headers.setLocation(location);
            return this;
        }

        @Override
        public BodyBuilder cacheControl(CacheControl cacheControl) {
            String ccValue = cacheControl.getHeaderValue();
            if (ccValue != null) {
                this.headers.setCacheControl(cacheControl.getHeaderValue());
            }
            return this;
        }

        @Override
        public BodyBuilder varyBy(String ... requestHeaders) {
            this.headers.setVary(Arrays.asList(requestHeaders));
            return this;
        }

        @Override
        public ResponseEntity<Void> build() {
            return this.body(null);
        }

        @Override
        public <T> ResponseEntity<T> body(T body) {
            return new ResponseEntity(body, this.headers, this.statusCode);
        }
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        public <T> ResponseEntity<T> body(T var1);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(HttpHeaders var1);

        public B allow(HttpMethod ... var1);

        public B eTag(String var1);

        public B lastModified(long var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public ResponseEntity<Void> build();
    }
}

