/*
 * Decompiled with CFR 0.152.
 */
package minium.script.js;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import minium.script.js.JsEngine;
import minium.script.js.JsVariable;
import minium.script.js.Jsonable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.MultiValueMap;

public class JsVariablePostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware {
    private Map<String, MultiValueMap<String, Object>> variables = Maps.newHashMap();
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String[] beanDefinitionNames;
        for (String beanDefinitionName : beanDefinitionNames = registry.getBeanDefinitionNames()) {
            MultiValueMap attrs;
            MethodMetadata metadata;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanDefinitionName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || (metadata = ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) == null || (attrs = metadata.getAllAnnotationAttributes(JsVariable.class.getName())) == null) continue;
            this.variables.put(beanDefinitionName, (MultiValueMap<String, Object>)attrs);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateEngine(JsEngine engine) {
        for (Map.Entry<String, MultiValueMap<String, Object>> entry : this.variables.entrySet()) {
            String beanDefinitionName = entry.getKey();
            MultiValueMap<String, Object> variable = entry.getValue();
            Object bean = this.beanFactory.getBean(beanDefinitionName);
            String jsVar = (String)variable.getFirst((Object)"value");
            String expression = (String)variable.getFirst((Object)"expression");
            Boolean deleteAfterExpression = (Boolean)variable.getFirst((Object)"deleteAfterExpression");
            if (jsVar == null) {
                jsVar = beanDefinitionName;
            }
            if (bean instanceof Jsonable) {
                engine.putJson(jsVar, ((Jsonable)bean).toJson());
            } else {
                engine.put(jsVar, bean);
            }
            try {
                if (Strings.isNullOrEmpty((String)expression)) continue;
                engine.eval(expression, 1);
            }
            finally {
                if (deleteAfterExpression == null || !deleteAfterExpression.booleanValue()) continue;
                engine.delete(jsVar);
            }
        }
    }
}

