/*
 * Decompiled with CFR 0.152.
 */
package minium.cucumber.rest.dto;

import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import minium.cucumber.rest.dto.CommentDTO;
import minium.cucumber.rest.dto.DataTableDTO;
import minium.cucumber.rest.dto.DocStringDTO;

public class StepDTO
implements Serializable {
    private static final long serialVersionUID = 578395699182857236L;
    private List<CommentDTO> comments;
    private String keyword;
    private String name;
    private Integer line;
    private List<DataTableDTO.DataTableRowDTO> rows;
    private DocStringDTO docString;

    public StepDTO() {
    }

    public StepDTO(Step step) {
        this.comments = CommentDTO.fromGherkinComments(step.getComments());
        this.keyword = step.getKeyword();
        this.name = step.getName();
        this.line = step.getLine();
        if (step.getRows() != null) {
            this.rows = new ArrayList<DataTableDTO.DataTableRowDTO>();
            for (DataTableRow gherkinRow : step.getRows()) {
                this.rows.add(new DataTableDTO.DataTableRowDTO(gherkinRow));
            }
        }
        if (step.getDocString() != null) {
            this.docString = new DocStringDTO(step.getDocString());
        }
    }

    public List<CommentDTO> getComments() {
        return this.comments;
    }

    public void setComments(List<CommentDTO> comments) {
        this.comments = comments;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getLine() {
        return this.line;
    }

    public void setLine(Integer line) {
        this.line = line;
    }

    public List<DataTableDTO.DataTableRowDTO> getRows() {
        return this.rows;
    }

    public void setRows(List<DataTableDTO.DataTableRowDTO> rows) {
        this.rows = rows;
    }

    public DocStringDTO getDocString() {
        return this.docString;
    }

    public void setDocString(DocStringDTO docString) {
        this.docString = docString;
    }

    public Step toStep() {
        return new Step(CommentDTO.toGherkinComments(this.comments), this.keyword, this.name, this.line, this.toGherkingRows(), this.docString == null ? null : this.docString.toDocString());
    }

    private List<DataTableRow> toGherkingRows() {
        if (this.rows == null) {
            return null;
        }
        ArrayList<DataTableRow> gherkinRows = new ArrayList<DataTableRow>();
        for (DataTableDTO.DataTableRowDTO row : this.rows) {
            gherkinRows.add(row.toDataTableRow());
        }
        return gherkinRows;
    }
}

