/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.tomcat.Jar;
import org.apache.tomcat.util.scan.NonClosingJarInputStream;

public abstract class AbstractInputStreamJar
implements Jar {
    private final URL jarFileURL;
    private NonClosingJarInputStream jarInputStream = null;
    private JarEntry entry = null;

    public AbstractInputStreamJar(URL jarFileUrl) {
        this.jarFileURL = jarFileUrl;
    }

    @Override
    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    @Override
    public void nextEntry() {
        if (this.jarInputStream == null) {
            try {
                this.jarInputStream = this.createJarInputStream();
            }
            catch (IOException e) {
                this.entry = null;
                return;
            }
        }
        try {
            this.entry = this.jarInputStream.getNextJarEntry();
        }
        catch (IOException ioe) {
            this.entry = null;
        }
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        return this.jarInputStream;
    }

    @Override
    public boolean entryExists(String name) throws IOException {
        this.gotoEntry(name);
        return this.entry != null;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        this.gotoEntry(name);
        if (this.entry == null) {
            return null;
        }
        return this.jarInputStream;
    }

    @Override
    public long getLastModified(String name) throws IOException {
        this.gotoEntry(name);
        if (this.entry == null) {
            return -1L;
        }
        return this.entry.getTime();
    }

    @Override
    public String getURL(String entry) {
        StringBuilder result = new StringBuilder("jar:");
        result.append(this.getJarFileURL().toExternalForm());
        result.append("!/");
        result.append(entry);
        return result.toString();
    }

    @Override
    public Manifest getManifest() throws IOException {
        this.reset();
        return this.jarInputStream.getManifest();
    }

    @Override
    public void reset() throws IOException {
        this.closeStream();
        this.entry = null;
        this.jarInputStream = this.createJarInputStream();
    }

    protected void closeStream() {
        if (this.jarInputStream != null) {
            try {
                this.jarInputStream.reallyClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract NonClosingJarInputStream createJarInputStream() throws IOException;

    private void gotoEntry(String name) throws IOException {
        if (this.entry != null && name.equals(this.entry.getName())) {
            return;
        }
        this.reset();
        JarEntry jarEntry = this.jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            if (name.equals(jarEntry.getName())) {
                this.entry = jarEntry;
                break;
            }
            jarEntry = this.jarInputStream.getNextJarEntry();
        }
    }
}

