/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass
public class CloseEvent
extends Event {
    private String reason_;
    private int code_;
    private boolean wasClean_;

    public CloseEvent() {
        this.setType("close");
        this.reason_ = "";
    }

    @Override
    public void eventCreated() {
        super.eventCreated();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLOSE_DEFAULT_TYPE_EMPTY)) {
            this.setType("");
        }
    }

    @Override
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        int code = 0;
        String reason = "";
        boolean wasClean = false;
        if (details != null && !Context.getUndefinedValue().equals(details)) {
            Boolean detailWasClean;
            String detailReason;
            Double detailCode = (Double)details.get((Object)"code");
            if (detailCode != null) {
                code = detailCode.intValue();
            }
            if ((detailReason = (String)details.get((Object)"reason")) != null) {
                reason = detailReason;
            }
            if ((detailWasClean = (Boolean)details.get((Object)"wasClean")) != null) {
                wasClean = detailWasClean;
            }
        }
        this.code_ = code;
        this.reason_ = reason;
        this.wasClean_ = wasClean;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public void initCloseEvent(String type, boolean bubbles, boolean cancelable, boolean wasClean, int reasonCode, String reason) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONCLOSE_INIT_CLOSE_EVENT_THROWS)) {
            Context.throwAsScriptRuntimeEx((Throwable)new IllegalArgumentException("Illegal call to initCloseEvent()"));
        }
        super.initEvent(type, bubbles, cancelable);
        this.wasClean_ = wasClean;
        this.code_ = reasonCode;
        this.reason_ = reason;
    }

    @JsxGetter
    public int getCode() {
        return this.code_;
    }

    public void setCode(int code) {
        this.code_ = code;
    }

    @JsxGetter
    public String getReason() {
        return this.reason_;
    }

    public void setReason(String reason) {
        this.reason_ = reason;
    }

    @JsxGetter
    public boolean getWasClean() {
        return this.wasClean_;
    }

    public void setWasClean(boolean wasClean) {
        this.wasClean_ = wasClean;
    }
}

