/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Arrays;

public class ObjectArrayElementComparisonStrategy<T>
extends StandardComparisonStrategy {
    private Comparator<? super T> elementComparator;

    public ObjectArrayElementComparisonStrategy(Comparator<? super T> elementComparator) {
        this.elementComparator = elementComparator;
    }

    @Override
    public boolean areEqual(Object actual, Object other) {
        if (actual == null && other == null) {
            return true;
        }
        if (actual == null || other == null) {
            return false;
        }
        return Arrays.isArray(actual) && Arrays.isArray(other) && this.compareElementsOf((Object[])actual, (Object[])other);
    }

    private boolean compareElementsOf(T[] actual, T[] other) {
        if (actual.length != other.length) {
            return false;
        }
        for (int i = 0; i < actual.length; ++i) {
            if (this.elementComparator.compare(actual[i], other[i]) == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ObjectArrayElementComparisonStrategy using " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf((Object)this.elementComparator);
    }

    @Override
    public String asText() {
        return "when comparing elements using " + StandardRepresentation.STANDARD_REPRESENTATION.toStringOf((Object)this.elementComparator);
    }

    @Override
    public boolean isStandard() {
        return false;
    }
}

