/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.data.Index;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.ObjectArrayElementComparisonStrategy;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.internal.RecursiveFieldByFieldComparator;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractObjectArrayAssert<S extends AbstractObjectArrayAssert<S, T>, T>
extends AbstractAssert<S, T[]>
implements IndexedObjectEnumerableAssert<AbstractObjectArrayAssert<S, T>, T>,
ArraySortedAssert<AbstractObjectArrayAssert<S, T>, T> {
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new HashMap();
    private Map<Class<?>, Comparator<?>> comparatorsForElementPropertyOrFieldTypes = new HashMap();

    public AbstractObjectArrayAssert(T[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (Object[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (Object[])this.actual, expected);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.actual, other);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S contains(T ... values) {
        this.arrays.assertContains(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsOnly(T ... values) {
        this.arrays.assertContainsOnly(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsOnlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public S hasSameElementsAs(Iterable<? extends T> iterable) {
        return (S)this.containsOnlyElementsOf((Iterable)iterable);
    }

    @Override
    public S containsOnlyOnce(T ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsExactly(T ... values) {
        this.arrays.assertContainsExactly(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsExactlyInAnyOrder(T ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsExactlyElementsOf(Iterable<? extends T> iterable) {
        return (S)this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public S containsSequence(T ... sequence) {
        this.arrays.assertContainsSequence(this.info, (Object[])this.actual, sequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsSubsequence(T ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, (Object[])this.actual, subsequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S contains(T value, Index index) {
        this.arrays.assertContains(this.info, (Object[])this.actual, value, index);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContain(T value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, value, index);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContain(T ... values) {
        this.arrays.assertDoesNotContain(this.info, (Object[])this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContainAnyElementsOf(Iterable<? extends T> iterable) {
        this.arrays.assertDoesNotContainAnyElementsOf(this.info, (Object[])this.actual, iterable);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S startsWith(T ... sequence) {
        this.arrays.assertStartsWith(this.info, (Object[])this.actual, sequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S endsWith(T ... sequence) {
        this.arrays.assertEndsWith(this.info, (Object[])this.actual, sequence);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S isSubsetOf(Iterable<? extends T> values) {
        this.arrays.assertIsSubsetOf(this.info, this.actual, values);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S isSubsetOf(T ... values) {
        this.arrays.assertIsSubsetOf(this.info, this.actual, java.util.Arrays.asList(values));
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsNull() {
        this.arrays.assertContainsNull(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S are(Condition<? super T> condition) {
        this.arrays.assertAre(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areNot(Condition<? super T> condition) {
        this.arrays.assertAreNot(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S have(Condition<? super T> condition) {
        this.arrays.assertHave(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S doNotHave(Condition<? super T> condition) {
        this.arrays.assertDoNotHave(this.info, (Object[])this.actual, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtLeast(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areAtLeastOne(Condition<? super T> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtMost(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S areExactly(int times, Condition<? super T> condition) {
        this.arrays.assertAreExactly(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S haveAtLeastOne(Condition<? super T> condition) {
        return (S)this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public S haveAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtLeast(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S haveAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtMost(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S haveExactly(int times, Condition<? super T> condition) {
        this.arrays.assertHaveExactly(this.info, (Object[])this.actual, times, condition);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasAtLeastOneElementOfType(Class<?> type) {
        this.arrays.assertHasAtLeastOneElementOfType(this.info, (Object[])this.actual, type);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S hasOnlyElementsOfType(Class<?> type) {
        this.arrays.assertHasOnlyElementsOfType(this.info, (Object[])this.actual, type);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (Object[])this.actual);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super T> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (Object[])this.actual, comparator);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S containsAll(Iterable<? extends T> iterable) {
        this.arrays.assertContainsAll(this.info, (Object[])this.actual, iterable);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super T> elementComparator) {
        this.arrays = new ObjectArrays(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new ObjectArrayElementComparisonStrategy<T>(elementComparator));
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = ObjectArrays.instance();
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    public <C> S usingComparatorForElementFieldsWithNames(Comparator<C> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    public <C> S usingComparatorForElementFieldsWithType(Comparator<C> comparator, Class<C> type) {
        this.comparatorsForElementPropertyOrFieldTypes.put(type, comparator);
        return (S)((AbstractObjectArrayAssert)this.myself);
    }

    public S usingFieldByFieldElementComparator() {
        return (S)this.usingElementComparator((Comparator)new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    public S usingRecursiveFieldByFieldElementComparator() {
        return (S)this.usingElementComparator((Comparator)new RecursiveFieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes));
    }

    public S usingElementComparatorOnFields(String ... fields) {
        return (S)this.usingElementComparator((Comparator)new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    public S usingElementComparatorIgnoringFields(String ... fields) {
        return (S)this.usingElementComparator((Comparator)new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.comparatorsForElementPropertyOrFieldTypes, fields));
    }

    public ObjectArrayAssert<Object> extracting(String fieldOrProperty) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(fieldOrProperty));
        return new ObjectArrayAssert<Object>(values);
    }

    public <P> ObjectArrayAssert<P> extracting(String fieldOrProperty, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(fieldOrProperty));
        return new ObjectArrayAssert<Object>(values);
    }

    public ObjectArrayAssert<Tuple> extracting(String ... propertiesOrFields) {
        Tuple[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.byName(propertiesOrFields));
        Tuple[] result = (Tuple[])java.util.Arrays.copyOf(values, values.length, Tuple[].class);
        return new ObjectArrayAssert<Tuple>(result);
    }

    public <U> ObjectArrayAssert<U> extracting(Extractor<? super T, U> extractor) {
        U[] extracted = FieldsOrPropertiesExtractor.extract((Object[])this.actual, extractor);
        return new ObjectArrayAssert<U>(extracted);
    }

    public <U, C extends Collection<U>> ObjectArrayAssert<U> flatExtracting(Extractor<? super T, C> extractor) {
        List<Collection> extractedValues = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), extractor);
        ArrayList result = Lists.newArrayList();
        for (Collection e : extractedValues) {
            result.addAll(e);
        }
        return new ObjectArrayAssert(IterableUtil.toArray(result));
    }

    public ObjectArrayAssert<Object> flatExtracting(String propertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList((Object[])this.actual), Extractors.byName(propertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return new ObjectArrayAssert<Object>(extractedValues.toArray());
    }

    public ObjectArrayAssert<Object> extractingResultOf(String method) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.resultOf(method));
        return new ObjectArrayAssert<Object>(values);
    }

    public <P> ObjectArrayAssert<P> extractingResultOf(String method, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract((Object[])this.actual, Extractors.resultOf(method));
        return new ObjectArrayAssert<Object>(values);
    }

    @Override
    public S inHexadecimal() {
        return (S)((AbstractObjectArrayAssert)super.inHexadecimal());
    }

    @Override
    public S inBinary() {
        return (S)((AbstractObjectArrayAssert)super.inBinary());
    }

    public S filteredOn(String propertyOrFieldName, Object expectedValue) {
        Iterable<Object> filteredIterable = Filters.filter((Object[])this.actual).with(propertyOrFieldName, expectedValue).get();
        return (S)new ObjectArrayAssert<Object>(IterableUtil.toArray(filteredIterable));
    }

    public S filteredOnNull(String propertyOrFieldName) {
        return this.filteredOn(propertyOrFieldName, (Object)null);
    }

    public S filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters<Object> filter = Filters.filter((Object[])this.actual).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return (S)new ObjectArrayAssert<Object>(IterableUtil.toArray(filter.get()));
    }

    public S filteredOn(Condition<? super T> condition) {
        Iterable<? super T> filteredIterable = Filters.filter((Object[])this.actual).being(condition).get();
        return (S)new ObjectArrayAssert<T>(IterableUtil.toArray(filteredIterable));
    }
}

