/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.rhino;

import cucumber.runtime.ParameterInfo;
import cucumber.runtime.StepDefinition;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.reflect.Type;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.tools.shell.Global;

public class RhinoStepDefinition
implements StepDefinition {
    private final Context cx;
    private final Scriptable scope;
    private final Global jsStepDefinition;
    private final NativeRegExp regexp;
    private final NativeFunction bodyFunc;
    private final StackTraceElement location;
    private final NativeFunction argumentsFromFunc;

    public RhinoStepDefinition(Context cx, Scriptable scope, Global jsStepDefinition, NativeRegExp regexp, NativeFunction bodyFunc, StackTraceElement location, NativeFunction argumentsFromFunc) {
        this.cx = cx;
        this.scope = scope;
        this.jsStepDefinition = jsStepDefinition;
        this.regexp = regexp;
        this.bodyFunc = bodyFunc;
        this.location = location;
        this.argumentsFromFunc = argumentsFromFunc;
    }

    public List<Argument> matchedArguments(Step step) {
        NativeJavaObject args = (NativeJavaObject)this.argumentsFromFunc.call(this.cx, this.scope, (Scriptable)this.jsStepDefinition, new Object[]{step.getName(), this});
        return args == null ? null : this.unwrap(args);
    }

    private List<Argument> unwrap(NativeJavaObject args) {
        return (List)args.unwrap();
    }

    public String getLocation(boolean detail) {
        return this.location.getFileName() + ":" + this.location.getLineNumber();
    }

    public Integer getParameterCount() {
        return this.bodyFunc.getArity();
    }

    public ParameterInfo getParameterType(int n, Type argumentType) {
        return new ParameterInfo(argumentType, null, null, null);
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        try {
            this.bodyFunc.call(this.cx, this.scope, this.scope, args);
        }
        catch (JavaScriptException e) {
            NativeJavaObject njo;
            Object unwrapped;
            Object value = e.getValue();
            if (value instanceof NativeJavaObject && (unwrapped = (njo = (NativeJavaObject)value).unwrap()) instanceof Throwable) {
                throw (Throwable)unwrapped;
            }
            throw e.getCause() == null ? e : e.getCause();
        }
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public String getPattern() {
        return this.regexp.toString();
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

